/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.bean.TimeEntry;
import com.taskadapter.redmineapi.bean.TimeEntryActivity;
import com.taskadapter.redmineapi.internal.DirectObjectsSearcher;
import com.taskadapter.redmineapi.internal.RequestParam;
import com.taskadapter.redmineapi.internal.ResultsWrapper;
import com.taskadapter.redmineapi.internal.Transport;
import java.util.List;
import java.util.Map;

public final class TimeEntryManager {
    private final Transport transport;

    TimeEntryManager(Transport transport) {
        this.transport = transport;
    }

    public List<TimeEntry> getTimeEntries() throws RedmineException {
        return this.transport.getObjectsList(TimeEntry.class, new RequestParam[0]);
    }

    public TimeEntry getTimeEntry(Integer id) throws RedmineException {
        return this.transport.getObject(TimeEntry.class, id, new RequestParam[0]);
    }

    public List<TimeEntry> getTimeEntriesForIssue(Integer issueId) throws RedmineException {
        return this.transport.getObjectsList(TimeEntry.class, new RequestParam("issue_id", Integer.toString(issueId)));
    }

    public ResultsWrapper<TimeEntry> getTimeEntries(Map<String, String> parameters) throws RedmineException {
        return DirectObjectsSearcher.getObjectsListNoPaging(this.transport, parameters, TimeEntry.class);
    }

    @Deprecated
    public TimeEntry createTimeEntry(TimeEntry obj) throws RedmineException {
        return obj.create();
    }

    @Deprecated
    public void deleteTimeEntry(Integer id) throws RedmineException {
        new TimeEntry(this.transport).setId(id).delete();
    }

    public List<TimeEntryActivity> getTimeEntryActivities() throws RedmineException {
        return this.transport.getObjectsList(TimeEntryActivity.class, new RequestParam[0]);
    }

    @Deprecated
    public void update(TimeEntry obj) throws RedmineException {
        obj.update();
    }
}

