/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.bean;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.bean.Attachment;
import com.taskadapter.redmineapi.bean.FluentStyle;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Property;
import com.taskadapter.redmineapi.bean.PropertyStorage;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.bean.WikiPage;
import com.taskadapter.redmineapi.internal.RequestParam;
import com.taskadapter.redmineapi.internal.Transport;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class WikiPageDetail
implements FluentStyle {
    public static final Property<WikiPageDetail> PARENT = new Property<WikiPageDetail>(WikiPageDetail.class, "parent");
    public static final Property<String> TEXT = new Property<String>(String.class, "text");
    public static final Property<String> PROJECT_KEY = new Property<String>(String.class, "project_key");
    public static final Property<User> USER = new Property<User>(User.class, "user");
    public static final Property<String> COMMENTS = new Property<String>(String.class, "comments");
    public static final Property<List<Attachment>> ATTACHMENTS = new Property<List>(List.class, "uploads");
    private final PropertyStorage storage = new PropertyStorage();
    private final WikiPage wikiPage = new WikiPage();
    private Transport transport;

    public WikiPageDetail(Transport transport) {
        this.storage.set(ATTACHMENTS, new ArrayList());
        this.setTransport(transport);
    }

    public String getComments() {
        return this.storage.get(COMMENTS);
    }

    public WikiPageDetail setComments(String comments) {
        this.storage.set(COMMENTS, comments);
        return this;
    }

    public List<Attachment> getAttachments() {
        return this.storage.get(ATTACHMENTS);
    }

    public WikiPageDetail setAttachments(List<Attachment> attachments) {
        this.storage.set(ATTACHMENTS, attachments);
        return this;
    }

    public WikiPageDetail getParent() {
        return this.storage.get(PARENT);
    }

    public WikiPageDetail setParent(WikiPageDetail parent) {
        this.storage.set(PARENT, parent);
        return this;
    }

    public String getText() {
        return this.storage.get(TEXT);
    }

    public WikiPageDetail setText(String text) {
        this.storage.set(TEXT, text);
        return this;
    }

    public User getUser() {
        return this.storage.get(USER);
    }

    public Integer getVersion() {
        return this.wikiPage.getVersion();
    }

    public WikiPageDetail setUser(User user) {
        this.storage.set(USER, user);
        return this;
    }

    public WikiPageDetail setTitle(String title) {
        this.wikiPage.setTitle(title);
        return this;
    }

    public WikiPageDetail setVersion(Integer version) {
        this.wikiPage.setVersion(version);
        return this;
    }

    public WikiPageDetail setCreatedOn(Date createdOn) {
        this.wikiPage.setCreatedOn(createdOn);
        return this;
    }

    public String toString() {
        return "WikiPageDetail{text='" + this.getText() + '\'' + '}';
    }

    public PropertyStorage getStorage() {
        return this.storage;
    }

    public String getTitle() {
        return this.wikiPage.getTitle();
    }

    public Date getCreatedOn() {
        return this.wikiPage.getCreatedOn();
    }

    public Date getUpdatedOn() {
        return this.wikiPage.getUpdatedOn();
    }

    public WikiPageDetail setUpdatedOn(Date updatedOn) {
        this.wikiPage.setUpdatedOn(updatedOn);
        return this;
    }

    public void create() throws RedmineException {
        this.update();
    }

    public void update() throws RedmineException {
        String urlSafeTitle = WikiPageDetail.getUrlSafeString(this.getTitle());
        this.transport.updateChildEntry(Project.class, this.getProjectKey(), this, urlSafeTitle, new RequestParam[0]);
    }

    @Override
    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public static String getUrlSafeString(String string) {
        String urlSafeTitle;
        try {
            urlSafeTitle = URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UnsupportedEncodingException when converting the page title to url: " + e.toString(), e);
        }
        return urlSafeTitle;
    }

    public WikiPageDetail setProjectKey(String projectKey) {
        this.storage.set(PROJECT_KEY, projectKey);
        return this;
    }

    public String getProjectKey() {
        return this.storage.get(PROJECT_KEY);
    }
}

