/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;

public abstract class Parcel {
    protected GenericTeradataConnection m_con;
    protected Log log;
    protected TDPacketStream buffer;
    protected int flavorPosition;
    protected short flavor;
    protected int length;
    protected boolean altHeader = false;
    public static final short PCLREQUEST = 1;
    public static final short PCLRUNSTARTUP = 2;
    public static final short PCLDATA = 3;
    public static final short PCLRESP = 4;
    public static final short PCLKEEPRESP = 5;
    public static final short PCLABORT = 6;
    public static final short PCLCANCEL = 7;
    public static final short PCLSUCCESS = 8;
    public static final short PCLFAILURE = 9;
    public static final short PCLRECORD = 10;
    public static final short PCLENDSTATEMENT = 11;
    public static final short PCLENDREQUEST = 12;
    public static final short PCLFMREQ = 13;
    public static final short PCLFMRUNSTARTUP = 14;
    public static final short PCLVALUE = 15;
    public static final short PCLNULLVALUE = 16;
    public static final short PCLOK = 17;
    public static final short PCLFIELD = 18;
    public static final short PCLNULLFIELD = 19;
    public static final short PCLTITLESTART = 20;
    public static final short PCLTITLEEND = 21;
    public static final short PCLFORMATSTART = 22;
    public static final short PCLFORMATEND = 23;
    public static final short PCLSIZESTART = 24;
    public static final short PCLSIZEEND = 25;
    public static final short PCLSIZE = 26;
    public static final short PCLRECSTART = 27;
    public static final short PCLRECEND = 28;
    public static final short PCLPROMPT = 29;
    public static final short PCLENDPROMPT = 30;
    public static final short PCLREWIND = 31;
    public static final short PCLNOP = 32;
    public static final short PCLWITH = 33;
    public static final short PCLPOSITION = 34;
    public static final short PCLENDWITH = 35;
    public static final short PCLLOGON = 36;
    public static final short PCLLOGOFF = 37;
    public static final short PCLRUN = 38;
    public static final short PCLRUNRESP = 39;
    public static final short PCLUCABORT = 40;
    public static final short PCLHOSTSTART = 41;
    public static final short PCLCONFIG = 42;
    public static final short PCLCONFIGRESP = 43;
    public static final short PCLSTATUS = 44;
    public static final short PCLIFPSWITCH = 45;
    public static final short PCLPOSSTART = 46;
    public static final short PCLPOSEND = 47;
    public static final short PCLBULKRESP = 48;
    public static final short PCLERROR = 49;
    public static final short PCLDATE = 50;
    public static final short PCLROW = 51;
    public static final short PCLHUTCREDBS = 52;
    public static final short PCLHUTDBLK = 53;
    public static final short PCLHUTDELTBL = 54;
    public static final short PCLHUTINSROW = 55;
    public static final short PCLHUTRBLK = 56;
    public static final short PCLHUTSNDBLK = 57;
    public static final short PCLENDACCLOG = 58;
    public static final short PCLHUTRELDBCLK = 59;
    public static final short PCLHUTNOP = 60;
    public static final short PCLHUTBLD = 61;
    public static final short PCLHUTBLDRSP = 62;
    public static final short PCLHUTGETDDT = 63;
    public static final short PCLHUTGETDDTRSP = 64;
    public static final short PCLHUTIDx = 65;
    public static final short PCLHUTIDxRsp = 66;
    public static final short PCLFIELDSTATUS = 67;
    public static final short PCLINDICDATA = 68;
    public static final short PCLINDICREQ = 69;
    public static final short PCLDATAINFO = 71;
    public static final short PCLIVRUNSTARTUP = 72;
    public static final short PCLOPTIONS = 85;
    public static final short PCLPREPINFO = 86;
    public static final short PCLCONNECT = 88;
    public static final short PCLLSN = 89;
    public static final short PCLCOMMIT = 90;
    public static final short PCLASSIGN = 100;
    public static final short PCLASSIGNRSP = 101;
    public static final short PCLMATCHTAG = 102;
    public static final short PCLEINDDATA = 104;
    public static final short PCLERRORCNT = 105;
    public static final short PCLSESSINFO = 106;
    public static final short PCLSESSINFORESP = 107;
    public static final short PCLSESSOPT = 114;
    public static final short PCLVOTEREQUEST = 115;
    public static final short PCLVOTETERM = 116;
    public static final short PCLCMMT2PC = 117;
    public static final short PCLABRT2PC = 118;
    public static final short PCLFORGET = 119;
    public static final short PCLCURSORHOST = 120;
    public static final short PCLCURSORDBC = 121;
    public static final short PCLFLAGGER = 122;
    public static final short PCLPREPINFOX = 125;
    public static final short PCLMULTITSR = 128;
    public static final short PCLSPOPTIONS = 129;
    public static final short PCLSSOAUTHREQ = 130;
    public static final short PCLSSOAUTHRESP = 131;
    public static final short PCLSSOREQ = 132;
    public static final short PCLSSODOMAIN = 133;
    public static final short PCLSSORESP = 134;
    public static final short PCLSSOAUTHINFO = 135;
    public static final short PCLUSERNAMEREQ = 136;
    public static final short PCLUSERNAMERESP = 137;
    public static final short PCLMULTIPARTDATA = 140;
    public static final short PCLENDMULTIPARTDATA = 141;
    public static final short PCLMULTIPARTINDICDATA = 142;
    public static final short PCLENDMULTIPARTINDICDATA = 143;
    public static final short PCLMULTIPARTRECORD = 144;
    public static final short PCLENDMULTIPARTRECORD = 145;
    public static final short PCLDATAINFOX = 146;
    public static final short PCLMUTIPARTRUNSTARTUP = 147;
    public static final short PCLMULTIPARTREQ = 148;
    public static final short PCLELICITDATAMAILBOX = 149;
    public static final short PCLELICITDATA = 150;
    public static final short PCLELICITFILE = 151;
    public static final short PCLELICITDATARECEIVED = 152;
    public static final short PCLBIGRESP = 153;
    public static final short PCLBIGKEEPRESP = 154;
    public static final short PCLHUTLOB = 155;
    public static final short PCLHUTLOBRSP = 156;
    public static final short PCLSETPOSITION = 157;
    public static final short PCLROWPOSITION = 158;
    public static final short PCLOFFSETPOSITION = 159;
    public static final short PCLERRORINFO = 164;
    public static final short PCLGTWCONFIG = 165;
    public static final short PCLCLIENTCONFIG = 166;
    public static final short PCLAUTHMECH = 167;
    public static final short PCLSTATEMENTINFO = 169;
    public static final short PCLSTATEMENTINFOEND = 170;
    public static final short PCLRESULTSET = 172;
    public static final short PCLRESULTSETSELECTION = 179;
    public static final short PCLCLIENTATTRIBUTES = 189;
    public static final short PCLFETCHROWCOUNT = 190;
    public static final short PCLSTMTERROR = 192;
    public static final short PCLSESSIONSTATUS = 194;
    public static final short PCLSESSIONSTATUSRESP = 195;
    public static final short PCLCONTINUECONTEXT = 196;
    public static final short PCLCONTROLDATASTART = 197;
    public static final short PCLCONTROLDATAEND = 198;
    public static final short PCLRECOVERABLEPROTOCOL = 200;
    public static final short PCLREDRIVE = 201;
    public static final short PCLACKREQUESTED = 202;
    public static final short PCLREDRIVESUPPORTED = 204;
    public static final short PCLSTMTSTATUS = 205;
    public static final short PCLSECURITYPOLICY = 206;
    public static final short PCLRECOVERABLENPSUPPORTED = 214;
    public static final short PCLSLOBRESPONSE = 215;
    public static final short PCLSLOBSTART = 220;
    public static final short PCLSLOBDATA = 221;
    public static final short PCLSLOBEND = 222;
    public static final short PCLCLIENTCONFIGTTUVERSION = 1;
    public static final short PCLCLIENTCONFIGTDGSS = 2;
    public static final short PCLCLIENTCONFIGRECOVERABLEPROTOCOL = 3;
    public static final short PCLCLIENTCONFIGCONTROLDATA = 4;
    public static final short PCLCLIENTCONFIGREDRIVE = 5;
    public static final short PCLCLIENTCONFIGSECURITYPOLICY = 8;
    public static final short PCLCLIENTCONFIGESS = 9;
    public static final short PCLCLIENTCONFIGNEGOMECH = 11;
    public static final short PCLCLIENTCONFIGIDP = 14;
    public static final short PCLCLIENTCONFIGTLS = 15;
    public static final short PCLGTWCONFIGUTF = 3;
    public static final short PCLGTWCONFIGRECOVERABLEPROTOCOL = 5;
    public static final short PCLGTWCONFIGCONTROLDATA = 6;
    public static final short PCLGTWCONFIGREDRIVE = 7;
    public static final short PCLGTWCONFIGSECPOLICY = 10;
    public static final short PCLGTWCONFIGNEGOMECH = 12;
    public static final short PCLGTWCONFIGIDP = 15;
    public static final short PCLGTWCONFIGPORTS = 16;
    public static final short PCLGTWCONFIGIDPSCOPE = 17;
    public static final short PCLSESSTATUSRESPOPENRESPEXT = 7;
    public static final short PCLGTWEXTSELFDEF = 1;
    private static final short ALTINDICATOR = Short.MIN_VALUE;
    public static final short PCLALTREQ = -32767;
    public static final short PCLALTRUNSTARTUP = -32766;
    public static final short PCLALTDATA = -32765;
    public static final short PCLALTCANCEL = -32761;
    public static final short PCLALTFMREQ = -32755;
    public static final short PCLALTFMRUNSTARTUP = -32754;
    public static final short PCLALTINDICDATA = -32700;
    public static final short PCLALTINDICREQ = -32699;
    public static final short PCLALTDATAINFO = -32697;
    public static final short PCLALTOPTIONS = -32683;
    public static final short PCLALTCURSORHOST = -32648;
    public static final short PCLALTMULTITSR = -32640;
    public static final short PCLALTSPOPTIONS = -32639;
    public static final short PCLALTBIGRESP = -32615;
    public static final short PCLALTBIGKEEPRESP = -32614;
    public static final short PCLALTRESP = -32764;
    public static final short PCLALTKEEPRESP = -32763;
    public static final short PCLALTMULTIPARTDATA = -32628;
    public static final short PCLALTENDMULTIPARTDATA = -32627;
    public static final short PCLALTMULTIPARTINDICDATA = -32626;
    public static final short PCLALTENDMULTIPARTINDICDATA = -32625;
    public static final short PCLALTDATAINFOX = -32622;
    public static final short PCLALTSETPOSITION = -32611;
    public static final short PCLALTSTATEMENTINFO = -32599;
    public static final short PCLALTSTATEMENTINFOEND = -32598;
    public static final short PCLALTSLOBSTART = -32548;
    public static final short PCLALTSLOBDATA = -32547;
    public static final short PCLALTSLOBEND = -32546;
    public static final short PCLALTSLOBRESPONSE = -32553;
    public static final int HEADER_LENGTH = 4;
    public static final int ALT_HEADER_LENGTH = 8;

    public static boolean isAPH(short s) {
        return (s & Short.MIN_VALUE) != 0;
    }

    public static short trueFlavor(short s) {
        return Parcel.isAPH(s) ? (s = (short)(s ^ Short.MIN_VALUE)) : s;
    }

    public Parcel(GenericTeradataConnection genericTeradataConnection) {
        this.m_con = genericTeradataConnection;
        this.log = genericTeradataConnection.getLog();
    }

    protected void initResponseParcel(TDPacketStream tDPacketStream) throws SQLException {
        this.buffer = tDPacketStream;
        this.flavorPosition = this.buffer.position();
        ParcelHeader parcelHeader = Parcel.readParcelHeader(this.buffer, this.log);
        this.flavor = parcelHeader.flavor;
        this.altHeader = parcelHeader.altHeader;
        this.length = parcelHeader.length;
    }

    public static ParcelHeader readParcelHeader(TDPacketStream tDPacketStream, Log log) throws SQLException {
        ParcelHeader parcelHeader = new ParcelHeader();
        short s = tDPacketStream.getShort();
        parcelHeader.flavor = Parcel.trueFlavor(s);
        parcelHeader.altHeader = Parcel.isAPH(s);
        if (parcelHeader.altHeader) {
            tDPacketStream.getShort();
            parcelHeader.length = tDPacketStream.getInt();
        } else {
            parcelHeader.length = tDPacketStream.getUnsignedShort();
        }
        if (log.isDebugEnabled()) {
            log.debug("readParcelHeader: encodedFlavor=0x" + Integer.toHexString(s & 0xFFFF) + " flavor=" + parcelHeader.flavor + " altHeader=" + parcelHeader.altHeader + " length=" + parcelHeader.length);
        }
        return parcelHeader;
    }

    public int headerLength() {
        return Parcel.calculateHeaderLength(this.altHeader);
    }

    public static int calculateHeaderLength(boolean bl) {
        return bl ? 8 : 4;
    }

    public int bodyLength() {
        return this.length - this.headerLength();
    }

    protected void setBuffer(TDPacketStream tDPacketStream) {
        this.buffer = tDPacketStream;
    }

    protected void createBuffer(int n) {
        this.buffer = new TDPacketStream(n);
    }

    protected void setFlavor(short s) {
        this.flavor = s;
    }

    protected void setLength(int n) {
        this.length = n;
    }

    public short getFlavor() {
        return this.flavor;
    }

    public int getLength() {
        return this.length;
    }

    public void setAltHeader(boolean bl) {
        this.altHeader = bl;
    }

    public TDPacketStream parcelHeaderToStream() throws SQLException {
        if (this.buffer != null) {
            this.buffer.rewind();
            this.buffer.putShort(this.flavor);
            if (this.altHeader) {
                this.buffer.putShort((short)0);
                this.buffer.putInt(this.length);
            } else {
                if (this.length > 65535) {
                    throw ErrorFactory.makeDriverJDBCException("TJ816", this.flavor, this.length, 65535);
                }
                this.buffer.putShort((short)this.length);
            }
        }
        return this.buffer;
    }

    public TDPacketStream toStream() throws SQLException {
        return this.parcelHeaderToStream();
    }

    public static class ParcelHeader {
        public short flavor;
        public boolean altHeader;
        public int length;

        public int headerLength() {
            return this.altHeader ? 8 : 4;
        }

        public int bodyLength() {
            return this.length - this.headerLength();
        }
    }
}

