/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2gss;

import com.teradata.tdgss.jgssp2gss.GssMinorStatus;
import com.teradata.tdgss.jgssp2gss.SspiMechanism;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssName;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class GssName
implements GSSName {
    private byte[] name;
    private Oid namespace;

    public GssName(byte[] byArray, Oid oid) throws GSSException {
        this.namespace = oid == null ? GSSName.NT_USER_NAME : oid;
        this.name = byArray;
    }

    @Override
    public boolean equals(GSSName gSSName) throws GSSException {
        return this.getStringNameType().equals(gSSName.getStringNameType()) && this.toString().equals(gSSName.toString());
    }

    @Override
    public boolean equals(Object object) {
        try {
            GSSName gSSName = (GSSName)object;
            return this.equals(gSSName);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (GSSException gSSException) {
            return false;
        }
    }

    @Override
    public GSSName canonicalize(Oid oid) throws GSSException {
        if (oid == null || !oid.equals(SspiMechanism.mechOid)) {
            throw new TdgssException(2, GssMinorStatus.GSSP2GSS_ERR_INVALID_INPUT);
        }
        return this;
    }

    @Override
    public byte[] export() throws GSSException {
        throw new TdgssException(16, GssMinorStatus.GSSP2GSS_ERR_CALL_INACCESSIBLE_WRITE);
    }

    @Override
    public String toString() {
        try {
            if (this.namespace.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16)) {
                return new String(this.name, "UTF-16");
            }
            if (this.namespace.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8)) {
                return new String(this.name, "UTF-8");
            }
            return this.name == null ? null : new String(this.name, "US-ASCII");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Oid getStringNameType() throws GSSException {
        return this.namespace;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isMN() {
        return true;
    }
}

