/*
 * Decompiled with CFR 0.152.
 */
package com.titusfortner.logging;

import com.titusfortner.logging.DriverLogger;
import java.io.File;
import org.openqa.selenium.chromium.ChromiumDriverLogLevel;

public abstract class ChromiumDriverLogger
extends DriverLogger {
    protected abstract String getLogLevelProperty();

    protected abstract String getAppendLogProperty();

    protected abstract String getReadableTimestampProperty();

    public void setLevel(ChromiumDriverLogLevel level) {
        System.setProperty(this.getLogLevelProperty(), level.name());
        this.ensureOutput();
    }

    public ChromiumDriverLogLevel getLevel() {
        String logLevel = System.getProperty(this.getLogLevelProperty());
        return logLevel == null ? null : ChromiumDriverLogLevel.valueOf((String)logLevel);
    }

    public void appendToLog(File logFile) {
        this.setFile(logFile);
        System.setProperty(this.getAppendLogProperty(), String.valueOf(true));
    }

    public void setReadableTimestamp(File logFile) {
        this.setFile(logFile);
        System.setProperty(this.getReadableTimestampProperty(), String.valueOf(true));
    }

    @Override
    protected void ensureLevel() {
        if (this.getLevel() == null) {
            this.setLevel(ChromiumDriverLogLevel.INFO);
        }
    }
}

