/*
 * Decompiled with CFR 0.152.
 */
package com.titusfortner.logging;

import com.titusfortner.logging.DriverLogger;
import org.openqa.selenium.firefox.FirefoxDriverLogLevel;

public class GeckoDriverLogger
extends DriverLogger {
    public static GeckoDriverLogger enable() {
        GeckoDriverLogger logger = new GeckoDriverLogger();
        logger.ensureEnabled();
        return logger;
    }

    public static GeckoDriverLogger all() {
        GeckoDriverLogger logger = new GeckoDriverLogger();
        logger.setLevel(FirefoxDriverLogLevel.TRACE);
        return logger;
    }

    public void setLevel(FirefoxDriverLogLevel level) {
        System.setProperty(this.getLogLevelProperty(), level.name());
        this.ensureOutput();
    }

    public FirefoxDriverLogLevel getLevel() {
        String logLevel = System.getProperty(this.getLogLevelProperty());
        return logLevel == null ? null : FirefoxDriverLogLevel.valueOf((String)logLevel);
    }

    public void setTruncate(Boolean truncate) {
        System.setProperty(this.getTruncateProperty(), String.valueOf(truncate == false));
        this.ensureLevel();
        this.ensureOutput();
    }

    @Override
    protected void ensureLevel() {
        if (this.getLevel() == null) {
            this.setLevel(FirefoxDriverLogLevel.INFO);
        }
    }

    @Override
    protected String getLogProperty() {
        return "webdriver.firefox.logfile";
    }

    private String getLogLevelProperty() {
        return "webdriver.firefox.logLevel";
    }

    private String getTruncateProperty() {
        return "webdriver.firefox.logTruncate";
    }
}

