/*
 * Decompiled with CFR 0.152.
 */
package com.tobiasdiez.easybind.optional;

import com.tobiasdiez.easybind.optional.PreboundOptionalBinding;
import java.util.Optional;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;

class FirstNonNullBinding<T>
extends PreboundOptionalBinding<T> {
    private final ObservableValue<? extends T>[] chain;
    private final InvalidationListener listener = this::srcInvalidated;
    private final InvalidationListener weakListener = new WeakInvalidationListener(this.listener);
    private int startAt = 0;

    @SafeVarargs
    public FirstNonNullBinding(ObservableValue<? extends T> ... chain) {
        super((Observable[])chain);
        this.chain = chain;
        for (ObservableValue<? extends T> observableValue : chain) {
            observableValue.addListener(this.weakListener);
        }
    }

    @Override
    public void dispose() {
        for (ObservableValue<? extends T> observableValue : this.chain) {
            observableValue.removeListener(this.weakListener);
        }
    }

    protected Optional<T> computeValue() {
        for (int i = this.startAt; i < this.chain.length; ++i) {
            Object val = this.chain[i].getValue();
            if (val == null) continue;
            this.startAt = i;
            return Optional.of(val);
        }
        this.startAt = this.chain.length;
        return Optional.empty();
    }

    private void srcInvalidated(Observable src) {
        for (int i = 0; i < this.chain.length; ++i) {
            if (this.chain[i] != src) continue;
            if (i > this.startAt) break;
            this.startAt = i;
            this.invalidate();
            break;
        }
    }
}

