/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt;

import com.totsp.mavenplugin.gwt.GWTSetup;
import com.totsp.mavenplugin.gwt.support.MakeCatalinaBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGWTMojo
extends AbstractMojo {
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    public static String GWT_PATH = null;
    public static String EXTA_ARG = null;
    public static final String JAVA_COMMAND = System.getProperty("java.home") != null ? FileUtils.normalize((String)(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java")) : "java";
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private String[] generatorRootClasses;
    private String generatorDestinationPackage;
    private String translatorDestinationPackage;
    private boolean translatorTwoWay;
    private boolean generateGettersAndSetters;
    private boolean generatePropertyChangeSupport;
    private boolean overwriteGeneratedClasses;
    private String groupId = "com.google.gwt";
    private String gwtVersion;
    private String type = "zip";
    private File buildDir;
    private File contextXml;
    private File webXml;
    private File gen;
    private File gwtHome;
    private File output;
    private File tomcat;
    private MavenProject project;
    private String[] compileTarget;
    private String extraJvmArgs;
    private String logLevel;
    private String runTarget;
    private String style;
    private boolean noServer;
    private int port;
    private int debugPort;
    private boolean debugSuspend;
    private String testFilter;
    private boolean sourcesOnPath;
    private boolean enableAssertions;

    public void setBuildDir(File buildDir) {
        this.buildDir = buildDir;
    }

    public File getBuildDir() {
        return this.buildDir;
    }

    public void setCompileTarget(String[] compileTarget) {
        this.compileTarget = compileTarget;
    }

    public String[] getCompileTarget() {
        return this.compileTarget;
    }

    public void setContextXml(File contextXml) {
        this.contextXml = contextXml;
    }

    public File getContextXml() {
        return this.contextXml;
    }

    public void setExtraJvmArgs(String extraJvmArgs) {
        this.extraJvmArgs = extraJvmArgs;
    }

    public String getExtraJvmArgs() {
        return this.extraJvmArgs;
    }

    public void setGen(File gen) {
        this.gen = gen;
    }

    public File getGen() {
        return this.gen;
    }

    public void setGwtHome(File gwtHome) {
        this.gwtHome = gwtHome;
    }

    public File getGwtHome() {
        return this.gwtHome;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setNoServer(boolean noServer) {
        this.noServer = noServer;
    }

    public boolean isNoServer() {
        return this.noServer;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public File getOutput() {
        return this.output;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setRunTarget(String runTarget) {
        this.runTarget = runTarget;
    }

    public String getRunTarget() {
        return this.runTarget;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        return this.style;
    }

    public void setTomcat(File tomcat) {
        this.tomcat = tomcat;
    }

    public File getTomcat() {
        return this.tomcat;
    }

    public void setWebXml(File webXml) {
        this.webXml = webXml;
    }

    public File getWebXml() {
        return this.webXml;
    }

    public Collection<File> buildClasspathList(boolean fRuntime) throws DependencyResolutionRequiredException {
        Iterator it;
        LinkedHashSet<File> items = new LinkedHashSet<File>();
        File GWTHome = this.getGwtHome();
        if (GWTHome == null) {
            GWTHome = new File(GWT_PATH);
        }
        items.add(GWTHome);
        items.add(new File(GWTHome, "gwt-user.jar"));
        items.add(new File(GWTHome, GWTSetup.guessDevJarName()));
        if (this.getSourcesOnPath()) {
            it = this.getProject().getCompileSourceRoots().iterator();
            while (it.hasNext()) {
                items.add(new File(it.next().toString()));
            }
            for (Resource r : this.project.getResources()) {
                items.add(new File(r.getDirectory()));
            }
        }
        items.add(new File(this.getProject().getBasedir(), "classes"));
        if (fRuntime) {
            it = this.getProject().getRuntimeClasspathElements().iterator();
            while (it.hasNext()) {
                items.add(new File(it.next().toString()));
            }
        } else {
            it = this.getProject().getCompileClasspathElements().iterator();
            while (it.hasNext()) {
                items.add(new File(it.next().toString()));
            }
        }
        it = this.getProject().getSystemClasspathElements().iterator();
        while (it.hasNext()) {
            items.add(new File(it.next().toString()));
        }
        return items;
    }

    public String guessArtifactId() {
        if (OS_NAME.startsWith("windows")) {
            return "gwt-windows";
        }
        if (OS_NAME.startsWith("mac")) {
            if (this.getGwtVersion().startsWith("1.4.") || this.getGwtVersion().startsWith("1.3.")) {
                return "gwt-mac";
            }
            if (System.getProperty("os.version").startsWith("10.5.")) {
                return "gwt-mac_10.5";
            }
            return "gwt-mac_10.4";
        }
        return "gwt-linux";
    }

    public Collection<File> buildRuntimeClasspathList() throws DependencyResolutionRequiredException {
        Collection<File> classpathItems = this.buildClasspathList(true);
        LinkedHashSet<File> items = new LinkedHashSet<File>();
        Iterator it = this.project.getResources().iterator();
        while (this.getSourcesOnPath() && it.hasNext()) {
            Resource r = (Resource)it.next();
            items.add(new File(r.getDirectory()));
        }
        items.addAll(classpathItems);
        return items;
    }

    public ClassLoader fixThreadClasspath() {
        try {
            ClassWorld world = new ClassWorld();
            ClassRealm root = world.newRealm("gwt-plugin", Thread.currentThread().getContextClassLoader());
            ClassRealm realm = root.createChildRealm("gwt-project");
            Iterator<File> it = this.buildClasspathList(false).iterator();
            while (it.hasNext()) {
                realm.addConstituent(it.next().toURI().toURL());
            }
            Thread.currentThread().setContextClassLoader(realm.getClassLoader());
            return realm.getClassLoader();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String buildClasspath(boolean fRuntime) throws DependencyResolutionRequiredException {
        StringBuffer sb = new StringBuffer();
        for (File path : this.buildClasspathList(fRuntime)) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            try {
                sb.append(path.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public void makeCatalinaBase() throws Exception {
        File webXml = this.getWebXml();
        String[] args = new String[]{this.getTomcat().getAbsolutePath(), webXml.getAbsolutePath()};
        MakeCatalinaBase.main((String[])args);
        if (this.getContextXml() != null && this.getContextXml().exists()) {
            FileUtils.copyFile((File)this.getContextXml(), (File)new File(this.getTomcat(), "conf/gwt/localhost/ROOT.xml"));
        }
    }

    public String[] getGeneratorRootClasses() {
        return this.generatorRootClasses;
    }

    public void setGeneratorRootClasses(String[] generatorRootClasses) {
        this.generatorRootClasses = generatorRootClasses;
    }

    public String getGeneratorDestinationPackage() {
        return this.generatorDestinationPackage;
    }

    public void setGeneratorDestinationPackage(String generatorDestinationPackage) {
        this.generatorDestinationPackage = generatorDestinationPackage;
    }

    public boolean isGenerateGettersAndSetters() {
        return this.generateGettersAndSetters;
    }

    public void setGenerateGettersAndSetters(boolean generateGettersAndSetters) {
        this.generateGettersAndSetters = generateGettersAndSetters;
    }

    public boolean isGeneratePropertyChangeSupport() {
        return this.generatePropertyChangeSupport;
    }

    public void setGeneratePropertyChangeSupport(boolean generatePropertyChangeSupport) {
        this.generatePropertyChangeSupport = generatePropertyChangeSupport;
    }

    public boolean isOverwriteGeneratedClasses() {
        return this.overwriteGeneratedClasses;
    }

    public void setOverwriteGeneratedClasses(boolean overwriteGeneratedClasses) {
        this.overwriteGeneratedClasses = overwriteGeneratedClasses;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public void setDebugPort(int debugPort) {
        this.debugPort = debugPort;
    }

    public boolean isDebugSuspend() {
        return this.debugSuspend;
    }

    public void setDebugSuspend(boolean debugSuspend) {
        this.debugSuspend = debugSuspend;
    }

    protected void copyFile(File source, File destination) throws IOException {
        FileOutputStream fos = new FileOutputStream(destination);
        FileInputStream fis = new FileInputStream(source);
        AbstractGWTMojo.copyStream(fis, fos);
        fos.flush();
        fos.close();
        fis.close();
    }

    protected static int copyStream(InputStream sourceStream, OutputStream destinationStream) throws IOException {
        int bytesRead = 0;
        int totalBytes = 0;
        byte[] buffer = new byte[1024];
        while (bytesRead >= 0) {
            bytesRead = sourceStream.read(buffer, 0, buffer.length);
            if (bytesRead > 0) {
                destinationStream.write(buffer, 0, bytesRead);
            }
            totalBytes += bytesRead;
        }
        return totalBytes;
    }

    protected File getGwtBinDirectory() throws IOException {
        return new File(this.getProject().getBuild().getOutputDirectory(), "../gwtBin").getCanonicalFile();
    }

    public String getTranslatorDestinationPackage() {
        return this.translatorDestinationPackage;
    }

    public void setTranslatorDestinationPackage(String translatorDestinationPackage) {
        this.translatorDestinationPackage = translatorDestinationPackage;
    }

    public boolean isTranslatorTwoWay() {
        return this.translatorTwoWay;
    }

    public void setTranslatorTwoWay(boolean translatorTwoWay) {
        this.translatorTwoWay = translatorTwoWay;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGwtVersion() {
        return this.gwtVersion;
    }

    public void setGwtVersion(String gwtVersion) {
        this.gwtVersion = gwtVersion;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCompileTargets(String[] targets) {
        this.compileTarget = targets;
    }

    public String getTestFilter() {
        return this.testFilter;
    }

    public void setTestFilter(String testFilter) {
        this.testFilter = testFilter;
    }

    public boolean getSourcesOnPath() {
        return this.sourcesOnPath;
    }

    public void setSourcesOnPath(boolean value) {
        this.sourcesOnPath = value;
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }
}

