/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt;

import com.totsp.mavenplugin.gwt.AbstractGWTMojo;
import com.totsp.mavenplugin.gwt.support.ExitException;
import com.totsp.mavenplugin.gwt.support.GwtWebInfProcessor;
import com.totsp.mavenplugin.gwt.util.FileIOUtils;
import java.io.File;
import java.util.Iterator;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class MergeWebXmlMojo
extends AbstractGWTMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().info((CharSequence)("copy source web.xml - " + this.getWebXml() + " to build dir (source web.xml required if mergewebxml execution is enabled)"));
            File destination = new File(this.getBuildDir(), "web.xml");
            if (!destination.exists()) {
                destination.getParentFile().mkdirs();
                destination.createNewFile();
            }
            FileIOUtils.copyFile(this.getWebXml(), destination);
            for (int i = 0; i < this.getCompileTarget().length; ++i) {
                File moduleFile = null;
                Iterator it = this.getProject().getCompileSourceRoots().iterator();
                while (it.hasNext() && moduleFile == null) {
                    File check = new File(it.next().toString() + "/" + this.getCompileTarget()[i].replace('.', '/') + ".gwt.xml");
                    this.getLog().debug((CharSequence)("Looking for file: " + check.getAbsolutePath()));
                    if (!check.exists()) continue;
                    moduleFile = check;
                }
                for (Resource r : this.getProject().getResources()) {
                    File check = new File(r.getDirectory() + "/" + this.getCompileTarget()[i].replace('.', '/') + ".gwt.xml");
                    this.getLog().debug((CharSequence)("Looking for file: " + check.getAbsolutePath()));
                    if (!check.exists()) continue;
                    moduleFile = check;
                }
                this.fixThreadClasspath();
                GwtWebInfProcessor processor = null;
                try {
                    if (moduleFile == null) {
                        throw new MojoExecutionException("module file null");
                    }
                    this.getLog().info((CharSequence)("Module file: " + moduleFile.getAbsolutePath()));
                    processor = new GwtWebInfProcessor(this.getCompileTarget()[i], moduleFile, destination.getAbsolutePath(), destination.getAbsolutePath(), this.isWebXmlServletPathAsIs());
                }
                catch (ExitException e) {
                    this.getLog().warn((CharSequence)e.getMessage());
                    return;
                }
                processor.process();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to merge web.xml", e);
        }
    }
}

