/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileIOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 1024;

    private FileIOUtils() {
    }

    public static int copyStream(InputStream sourceStream, OutputStream destinationStream) throws IOException {
        int bytesRead = 0;
        int totalBytes = 0;
        byte[] buffer = new byte[1024];
        while (bytesRead >= 0) {
            bytesRead = sourceStream.read(buffer, 0, buffer.length);
            if (bytesRead > 0) {
                destinationStream.write(buffer, 0, bytesRead);
            }
            totalBytes += bytesRead;
        }
        destinationStream.flush();
        destinationStream.close();
        return totalBytes;
    }

    public static void copyFile(File source, File destination) throws IOException {
        FileOutputStream fos = new FileOutputStream(destination);
        FileInputStream fis = new FileInputStream(source);
        FileIOUtils.copyStream(fis, fos);
        fos.flush();
        fos.close();
        fis.close();
    }
}

