/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProcessWatcher {
    public static final long DEFAULT_SLEEP = 200L;
    Process process;
    Object command;
    String[] envirionment;
    File dir;
    StreamSucker out;
    StreamSucker err;

    private ProcessWatcher(Object command, String[] envirionment, File dir) {
        this.command = command;
        this.envirionment = envirionment;
        this.dir = dir;
    }

    public ProcessWatcher(String command, String[] envirionment, File dir) {
        this((Object)command, envirionment, dir);
    }

    public ProcessWatcher(String[] command, String[] envirionment, File dir) {
        this((Object)command, envirionment, dir);
    }

    public ProcessWatcher(String command, String[] envirionment) {
        this((Object)command, envirionment, null);
    }

    public ProcessWatcher(String[] command, String[] envirionment) {
        this((Object)command, envirionment, null);
    }

    public ProcessWatcher(String command) {
        this((Object)command, null, null);
    }

    public ProcessWatcher(String[] command) {
        this((Object)command, null, null);
    }

    public void startProcess() throws IOException {
        this.process = this.command instanceof String[] ? Runtime.getRuntime().exec((String[])this.command, this.envirionment, this.dir) : Runtime.getRuntime().exec((String)this.command, this.envirionment, this.dir);
        if (this.out == null) {
            this.out = new StreamSucker(new NulStream());
        }
        if (this.err == null) {
            this.err = new StreamSucker(new NulStream());
        }
        this.out.setIn(this.process.getInputStream());
        this.err.setIn(this.process.getErrorStream());
        this.out.start();
        this.err.start();
    }

    public void startProcess(OutputStream stdout, OutputStream stderr) throws IOException {
        if (stdout != null) {
            this.out = new StreamSucker(stdout);
        }
        if (stderr != null) {
            this.err = new StreamSucker(stderr);
        }
        this.startProcess();
    }

    public void startProcess(StringBuffer stdout, StringBuffer stderr) throws IOException {
        if (stdout != null) {
            this.out = new StreamSucker(new StringBufferStream(stdout));
        }
        if (stderr != null) {
            this.err = new StreamSucker(new StringBufferStream(stderr));
        }
        this.startProcess();
    }

    public OutputStream getStdIn() {
        return this.process.getOutputStream();
    }

    public int exitValue() {
        return this.process.exitValue();
    }

    public void destroy() {
        this.process.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitFor() throws InterruptedException {
        try {
            this.process.waitFor();
        }
        finally {
            this.out.shutdown();
            this.err.shutdown();
        }
        this.out.join();
        this.err.join();
        return this.process.exitValue();
    }

    public static class StringBufferStream
    extends OutputStream {
        final StringBuffer buf;

        public StringBufferStream(StringBuffer buf) {
            this.buf = buf;
        }

        public void write(int i) throws IOException {
            this.buf.append((char)i);
        }
    }

    public static class NulStream
    extends OutputStream {
        public void write(int i) throws IOException {
        }
    }

    public static class StreamSucker
    extends Thread {
        private final long sleeptime;
        private final OutputStream out;
        private InputStream in;
        volatile boolean allDone = false;

        public StreamSucker(OutputStream out, long sleeptime) {
            this.sleeptime = sleeptime;
            this.out = out == null ? new NulStream() : out;
        }

        public StreamSucker(OutputStream out) {
            this(out, 200L);
        }

        public StreamSucker() {
            this(null, 200L);
        }

        public void shutdown() {
            this.allDone = true;
        }

        public void siphonAvailableBytes(byte[] buf) throws IOException {
            int available = this.getIn().available();
            while (available > 0) {
                available = this.getIn().read(buf);
                this.getOut().write(buf, 0, available);
                available = this.getIn().available();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] buf = new byte[4096];
            try {
                while (!this.allDone) {
                    StreamSucker streamSucker = this;
                    synchronized (streamSucker) {
                        this.wait(this.getSleeptime());
                    }
                    this.siphonAvailableBytes(buf);
                }
                this.siphonAvailableBytes(buf);
            }
            catch (InterruptedException e) {
            }
            catch (IOException e) {
            }
            finally {
                try {
                    this.out.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public long getSleeptime() {
            return this.sleeptime;
        }

        public OutputStream getOut() {
            return this.out;
        }

        public InputStream getIn() {
            return this.in;
        }

        public void setIn(InputStream in) {
            this.in = in;
        }
    }
}

