/*
 * Decompiled with CFR 0.152.
 */
package parquet.example.data.simple;

import java.util.ArrayList;
import java.util.List;
import parquet.example.data.Group;
import parquet.example.data.simple.BinaryValue;
import parquet.example.data.simple.BooleanValue;
import parquet.example.data.simple.DoubleValue;
import parquet.example.data.simple.FloatValue;
import parquet.example.data.simple.Int96Value;
import parquet.example.data.simple.IntegerValue;
import parquet.example.data.simple.LongValue;
import parquet.example.data.simple.NanoTime;
import parquet.example.data.simple.Primitive;
import parquet.io.api.Binary;
import parquet.io.api.RecordConsumer;
import parquet.schema.GroupType;
import parquet.schema.Type;

public class SimpleGroup
extends Group {
    private final GroupType schema;
    private final List<Object>[] data;

    public SimpleGroup(GroupType schema) {
        this.schema = schema;
        this.data = new List[schema.getFields().size()];
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            this.data[i] = new ArrayList<Object>();
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String result = "";
        int i = 0;
        for (Type field : this.schema.getFields()) {
            String name = field.getName();
            List<Object> values = this.data[i];
            ++i;
            if (values == null || values.size() <= 0) continue;
            for (Object value : values) {
                result = result + indent + name;
                if (value == null) {
                    result = result + ": NULL\n";
                    continue;
                }
                if (value instanceof Group) {
                    result = result + "\n" + ((SimpleGroup)value).toString(indent + "  ");
                    continue;
                }
                result = result + ": " + value.toString() + "\n";
            }
        }
        return result;
    }

    @Override
    public Group addGroup(int fieldIndex) {
        SimpleGroup g = new SimpleGroup(this.schema.getType(fieldIndex).asGroupType());
        this.add(fieldIndex, (Group)g);
        return g;
    }

    @Override
    public Group getGroup(int fieldIndex, int index) {
        return (Group)this.getValue(fieldIndex, index);
    }

    private Object getValue(int fieldIndex, int index) {
        List<Object> list;
        try {
            list = this.data[fieldIndex];
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("not found " + fieldIndex + "(" + this.schema.getFieldName(fieldIndex) + ") in group:\n" + this);
        }
        try {
            return list.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("not found " + fieldIndex + "(" + this.schema.getFieldName(fieldIndex) + ") element number " + index + " in group:\n" + this);
        }
    }

    private void add(int fieldIndex, Primitive value) {
        Type type = this.schema.getType(fieldIndex);
        List<Object> list = this.data[fieldIndex];
        if (!type.isRepetition(Type.Repetition.REPEATED) && !list.isEmpty()) {
            throw new IllegalStateException("field " + fieldIndex + " (" + type.getName() + ") can not have more than one value: " + list);
        }
        list.add(value);
    }

    @Override
    public int getFieldRepetitionCount(int fieldIndex) {
        List<Object> list = this.data[fieldIndex];
        return list == null ? 0 : list.size();
    }

    @Override
    public String getValueToString(int fieldIndex, int index) {
        return String.valueOf(this.getValue(fieldIndex, index));
    }

    @Override
    public String getString(int fieldIndex, int index) {
        return ((BinaryValue)this.getValue(fieldIndex, index)).getString();
    }

    @Override
    public int getInteger(int fieldIndex, int index) {
        return ((IntegerValue)this.getValue(fieldIndex, index)).getInteger();
    }

    @Override
    public long getLong(int fieldIndex, int index) {
        return ((LongValue)this.getValue(fieldIndex, index)).getLong();
    }

    @Override
    public double getDouble(int fieldIndex, int index) {
        return ((DoubleValue)this.getValue(fieldIndex, index)).getDouble();
    }

    @Override
    public float getFloat(int fieldIndex, int index) {
        return ((FloatValue)this.getValue(fieldIndex, index)).getFloat();
    }

    @Override
    public boolean getBoolean(int fieldIndex, int index) {
        return ((BooleanValue)this.getValue(fieldIndex, index)).getBoolean();
    }

    @Override
    public Binary getBinary(int fieldIndex, int index) {
        return ((BinaryValue)this.getValue(fieldIndex, index)).getBinary();
    }

    public NanoTime getTimeNanos(int fieldIndex, int index) {
        return NanoTime.fromInt96((Int96Value)this.getValue(fieldIndex, index));
    }

    @Override
    public Binary getInt96(int fieldIndex, int index) {
        return ((Int96Value)this.getValue(fieldIndex, index)).getInt96();
    }

    @Override
    public void add(int fieldIndex, int value) {
        this.add(fieldIndex, new IntegerValue(value));
    }

    @Override
    public void add(int fieldIndex, long value) {
        this.add(fieldIndex, new LongValue(value));
    }

    @Override
    public void add(int fieldIndex, String value) {
        this.add(fieldIndex, new BinaryValue(Binary.fromString(value)));
    }

    @Override
    public void add(int fieldIndex, NanoTime value) {
        this.add(fieldIndex, value.toInt96());
    }

    @Override
    public void add(int fieldIndex, boolean value) {
        this.add(fieldIndex, new BooleanValue(value));
    }

    @Override
    public void add(int fieldIndex, Binary value) {
        switch (this.getType().getType(fieldIndex).asPrimitiveType().getPrimitiveTypeName()) {
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                this.add(fieldIndex, new BinaryValue(value));
                break;
            }
            case INT96: {
                this.add(fieldIndex, new Int96Value(value));
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.getType().asPrimitiveType().getName() + " not supported for Binary");
            }
        }
    }

    @Override
    public void add(int fieldIndex, float value) {
        this.add(fieldIndex, new FloatValue(value));
    }

    @Override
    public void add(int fieldIndex, double value) {
        this.add(fieldIndex, new DoubleValue(value));
    }

    @Override
    public void add(int fieldIndex, Group value) {
        this.data[fieldIndex].add(value);
    }

    @Override
    public GroupType getType() {
        return this.schema;
    }

    @Override
    public void writeValue(int field, int index, RecordConsumer recordConsumer) {
        ((Primitive)this.getValue(field, index)).writeValue(recordConsumer);
    }
}

