/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.util.Extensible;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.net.InetAddress;
import java.net.UnknownHostException;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class NameResolver {
    private static final String JVM_PROPERTY_POSITIVE_ADDRESS_CACHE_TTL_SECONDS = "networkaddress.cache.ttl";
    private static final String JVM_PROPERTY_NEGATIVE_ADDRESS_CACHE_TTL_SECONDS = "networkaddress.cache.negative.ttl";

    protected NameResolver() {
    }

    public InetAddress getByName(String host) throws UnknownHostException, SecurityException {
        return InetAddress.getByName(host);
    }

    public InetAddress[] getAllByName(String host) throws UnknownHostException, SecurityException {
        return InetAddress.getAllByName(host);
    }

    public String getHostName(InetAddress inetAddress) {
        return inetAddress.getHostName();
    }

    public String getCanonicalHostName(InetAddress inetAddress) {
        return inetAddress.getCanonicalHostName();
    }

    public InetAddress getLocalHost() throws UnknownHostException, SecurityException {
        return InetAddress.getLocalHost();
    }

    public InetAddress getLoopbackAddress() {
        return InetAddress.getLoopbackAddress();
    }

    public static void setJVMSuccessfulLookupCacheTTLSeconds(int seconds) {
        if (seconds < 0) {
            StaticUtils.setSystemProperty(JVM_PROPERTY_POSITIVE_ADDRESS_CACHE_TTL_SECONDS, "-1");
        } else {
            StaticUtils.setSystemProperty(JVM_PROPERTY_POSITIVE_ADDRESS_CACHE_TTL_SECONDS, String.valueOf(seconds));
        }
    }

    public static void setJVMUnsuccessfulLookupCacheTTLSeconds(int seconds) {
        if (seconds < 0) {
            StaticUtils.setSystemProperty(JVM_PROPERTY_NEGATIVE_ADDRESS_CACHE_TTL_SECONDS, "-1");
        } else {
            StaticUtils.setSystemProperty(JVM_PROPERTY_NEGATIVE_ADDRESS_CACHE_TTL_SECONDS, String.valueOf(seconds));
        }
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(StringBuilder var1);
}

