/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.LogField;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONLogMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class JSONLogMessage
implements LogMessage {
    private static final long serialVersionUID = 997950529069507711L;
    @NotNull
    private final JSONObject jsonObject;
    private final long timestampValue;
    @NotNull
    private final Map<String, List<String>> logFields;
    @NotNull
    private final String logMessageString;
    @Nullable
    private final String logType;

    protected JSONLogMessage(@NotNull JSONObject jsonObject) throws LogException {
        this.jsonObject = jsonObject;
        this.logMessageString = jsonObject.toSingleLineString();
        JSONValue timestampJSONValue = jsonObject.getField(JSONFormattedAccessLogFields.TIMESTAMP.getFieldName());
        if (timestampJSONValue == null) {
            throw new LogException(this.logMessageString, JSONLogMessages.ERR_JSON_LOG_MESSAGE_MISSING_TIMESTAMP.get(this.logMessageString, JSONFormattedAccessLogFields.TIMESTAMP.getFieldName()));
        }
        if (!(timestampJSONValue instanceof JSONString)) {
            throw new LogException(this.logMessageString, JSONLogMessages.ERR_JSON_LOG_MESSAGE_TIMESTAMP_NOT_STRING.get(this.logMessageString, JSONFormattedAccessLogFields.TIMESTAMP.getFieldName()));
        }
        try {
            this.timestampValue = StaticUtils.decodeRFC3339Time(((JSONString)timestampJSONValue).stringValue()).getTime();
        }
        catch (ParseException e) {
            Debug.debugException(e);
            throw new LogException(this.logMessageString, JSONLogMessages.ERR_JSON_LOG_MESSAGE_MALFORMED_TIMESTAMP.get(this.logMessageString, JSONFormattedAccessLogFields.TIMESTAMP.getFieldName()), e);
        }
        LinkedHashMap<String, List<String>> fieldMap = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, JSONValue> e : jsonObject.getFields().entrySet()) {
            fieldMap.put(e.getKey(), JSONLogMessage.valueToStrings(e.getValue()));
        }
        this.logFields = Collections.unmodifiableMap(fieldMap);
        this.logType = this.getString(JSONFormattedAccessLogFields.LOG_TYPE);
    }

    @NotNull
    static List<String> valueToStrings(@NotNull JSONValue value) {
        if (value instanceof JSONArray) {
            JSONArray a = (JSONArray)value;
            List<JSONValue> valueList = a.getValues();
            ArrayList<String> valueStrings = new ArrayList<String>(valueList.size());
            for (JSONValue v : valueList) {
                if (v instanceof JSONString) {
                    valueStrings.add(((JSONString)v).stringValue());
                    continue;
                }
                valueStrings.add(v.toSingleLineString());
            }
            return Collections.unmodifiableList(valueStrings);
        }
        if (value instanceof JSONString) {
            return Collections.singletonList(((JSONString)value).stringValue());
        }
        return Collections.singletonList(value.toSingleLineString());
    }

    @NotNull
    public final JSONObject getJSONObject() {
        return this.jsonObject;
    }

    @Override
    @NotNull
    public final Date getTimestamp() {
        return new Date(this.timestampValue);
    }

    @Nullable
    public final String getLogType() {
        return this.logType;
    }

    @Override
    @NotNull
    public final Map<String, List<String>> getFields() {
        return this.logFields;
    }

    @Override
    @Nullable
    public final Boolean getBoolean(@NotNull LogField logField) throws LogException {
        JSONValue fieldValue = this.getFirstValue(logField);
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof JSONBoolean) {
            return ((JSONBoolean)fieldValue).booleanValue();
        }
        if (fieldValue instanceof JSONString) {
            String stringValue = ((JSONString)fieldValue).stringValue();
            if (stringValue.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (stringValue.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            throw new LogException(this.logMessageString, JSONLogMessages.ERR_JSON_LOG_MESSAGE_VALUE_NOT_BOOLEAN.get(logField.getFieldName(), this.logMessageString));
        }
        throw new LogException(this.logMessageString, JSONLogMessages.ERR_JSON_LOG_MESSAGE_VALUE_NOT_BOOLEAN.get(logField.getFieldName(), this.logMessageString));
    }

    @Nullable
    final Boolean getBooleanNoThrow(@NotNull LogField logField) {
        try {
            return this.getBoolean(logField);
        }
        catch (LogException e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    @Nullable
    public final Date getGeneralizedTime(@NotNull LogField logField) throws LogException {
        JSONValue fieldValue = this.getFirstValue(logField);
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof JSONString) {
            String stringValue = ((JSONString)fieldValue).stringValue();
            try {
                return StaticUtils.decodeGeneralizedTime(stringValue);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LogException(this.logMessageString, JSONLogMessages.ERR_JSON_LOG_MESSAGE_VALUE_NOT_GENERALIZED_TIME.get(logField.getFieldName(), this.logMessageString), e);
            }
        }
        throw new LogException(this.logMessageString, JSONLogMessages.ERR_JSON_LOG_MESSAGE_VALUE_NOT_GENERALIZED_TIME.get(logField.getFieldName(), this.logMessageString));
    }

    @Nullable
    final Date getGeneralizedTimeNoThrow(@NotNull LogField logField) {
        try {
            return this.getGeneralizedTime(logField);
        }
        catch (LogException e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    @Nullable
    public final Double getDouble(@NotNull LogField logField) throws LogException {
        JSONValue fieldValue = this.getFirstValue(logField);
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof JSONNumber) {
            return ((JSONNumber)fieldValue).getValue().doubleValue();
        }
        if (fieldValue instanceof JSONString) {
            String stringValue = ((JSONString)fieldValue).stringValue();
            try {
                return Double.valueOf(stringValue);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LogException(this.logMessageString, JSONLogMessages.ERR_JSON_LOG_MESSAGE_VALUE_NOT_FLOATING_POINT.get(logField.getFieldName(), this.logMessageString), e);
            }
        }
        throw new LogException(this.logMessageString, JSONLogMessages.ERR_JSON_LOG_MESSAGE_VALUE_NOT_FLOATING_POINT.get(logField.getFieldName(), this.logMessageString));
    }

    @Nullable
    final Double getDoubleNoThrow(@NotNull LogField logField) {
        try {
            return this.getDouble(logField);
        }
        catch (LogException e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    @Nullable
    public final Integer getInteger(@NotNull LogField logField) throws LogException {
        JSONValue fieldValue = this.getFirstValue(logField);
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof JSONNumber) {
            try {
                return ((JSONNumber)fieldValue).getValue().intValueExact();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LogException(this.logMessageString, JSONLogMessages.ERR_JSON_LOG_MESSAGE_VALUE_NOT_INTEGER.get(logField.getFieldName(), this.logMessageString), e);
            }
        }
        if (fieldValue instanceof JSONString) {
            String stringValue = ((JSONString)fieldValue).stringValue();
            try {
                return Integer.parseInt(stringValue);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LogException(this.logMessageString, JSONLogMessages.ERR_JSON_LOG_MESSAGE_VALUE_NOT_INTEGER.get(logField.getFieldName(), this.logMessageString), e);
            }
        }
        throw new LogException(this.logMessageString, JSONLogMessages.ERR_JSON_LOG_MESSAGE_VALUE_NOT_INTEGER.get(logField.getFieldName(), this.logMessageString));
    }

    @Nullable
    final Integer getIntegerNoThrow(@NotNull LogField logField) {
        try {
            return this.getInteger(logField);
        }
        catch (LogException e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    @Nullable
    public final Long getLong(@NotNull LogField logField) throws LogException {
        JSONValue fieldValue = this.getFirstValue(logField);
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof JSONNumber) {
            try {
                return ((JSONNumber)fieldValue).getValue().longValueExact();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LogException(this.logMessageString, JSONLogMessages.ERR_JSON_LOG_MESSAGE_VALUE_NOT_INTEGER.get(logField.getFieldName(), this.logMessageString), e);
            }
        }
        if (fieldValue instanceof JSONString) {
            String stringValue = ((JSONString)fieldValue).stringValue();
            try {
                return Long.parseLong(stringValue);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LogException(this.logMessageString, JSONLogMessages.ERR_JSON_LOG_MESSAGE_VALUE_NOT_INTEGER.get(logField.getFieldName(), this.logMessageString), e);
            }
        }
        throw new LogException(this.logMessageString, JSONLogMessages.ERR_JSON_LOG_MESSAGE_VALUE_NOT_INTEGER.get(logField.getFieldName(), this.logMessageString));
    }

    @Nullable
    final Long getLongNoThrow(@NotNull LogField logField) {
        try {
            return this.getLong(logField);
        }
        catch (LogException e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    @Nullable
    public final Date getRFC3339Timestamp(@NotNull LogField logField) throws LogException {
        JSONValue fieldValue = this.getFirstValue(logField);
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof JSONString) {
            String stringValue = ((JSONString)fieldValue).stringValue();
            try {
                return StaticUtils.decodeRFC3339Time(stringValue);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LogException(this.logMessageString, JSONLogMessages.ERR_JSON_LOG_MESSAGE_VALUE_NOT_RFC_3339_TIME.get(logField.getFieldName(), this.logMessageString), e);
            }
        }
        throw new LogException(this.logMessageString, JSONLogMessages.ERR_JSON_LOG_MESSAGE_VALUE_NOT_RFC_3339_TIME.get(logField.getFieldName(), this.logMessageString));
    }

    @Nullable
    final Date getRFC3339TimestampNoThrow(@NotNull LogField logField) {
        try {
            return this.getRFC3339Timestamp(logField);
        }
        catch (LogException e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    @Nullable
    public final String getString(@NotNull LogField logField) {
        JSONValue fieldValue = this.getFirstValue(logField);
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof JSONString) {
            return ((JSONString)fieldValue).stringValue();
        }
        return fieldValue.toSingleLineString();
    }

    @NotNull
    final List<String> getStringList(@NotNull LogField logField) {
        JSONValue fieldValue = this.jsonObject.getField(logField.getFieldName());
        if (fieldValue == null) {
            return Collections.emptyList();
        }
        if (fieldValue instanceof JSONString) {
            return Collections.singletonList(((JSONString)fieldValue).stringValue());
        }
        if (fieldValue instanceof JSONArray) {
            List<JSONValue> values = ((JSONArray)fieldValue).getValues();
            ArrayList<String> stringValues = new ArrayList<String>(values.size());
            for (JSONValue v : values) {
                if (!(v instanceof JSONString)) continue;
                stringValues.add(((JSONString)v).stringValue());
            }
            return Collections.unmodifiableList(stringValues);
        }
        return Collections.emptyList();
    }

    @NotNull
    final Set<String> getStringSet(@NotNull LogField logField) {
        return Collections.unmodifiableSet(new LinkedHashSet<String>(this.getStringList(logField)));
    }

    @Nullable
    JSONValue getFirstValue(@NotNull LogField logField) {
        JSONValue value = this.jsonObject.getField(logField.getFieldName());
        if (value == null) {
            return null;
        }
        if (value instanceof JSONArray) {
            List<JSONValue> arrayValues = ((JSONArray)value).getValues();
            if (arrayValues.isEmpty()) {
                return null;
            }
            return arrayValues.get(0);
        }
        return value;
    }

    @Override
    @NotNull
    public final String toString() {
        return this.logMessageString;
    }
}

