/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.SecurityNegotiationAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONSecurityNegotiationAccessLogMessage
extends JSONAccessLogMessage
implements SecurityNegotiationAccessLogMessage {
    private static final long serialVersionUID = 1857193839548987368L;
    @NotNull
    private final Map<String, String> negotiationProperties;
    @Nullable
    private final String cipher;
    @Nullable
    private final String protocol = this.getString(JSONFormattedAccessLogFields.PROTOCOL);

    public JSONSecurityNegotiationAccessLogMessage(@NotNull JSONObject jsonObject) throws LogException {
        super(jsonObject);
        this.cipher = this.getString(JSONFormattedAccessLogFields.CIPHER);
        LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>();
        List<JSONValue> propertiesObjects = jsonObject.getFieldAsArray(JSONFormattedAccessLogFields.SECURITY_NEGOTIATION_PROPERTIES.getFieldName());
        if (propertiesObjects != null) {
            for (JSONValue v : propertiesObjects) {
                if (!(v instanceof JSONObject)) continue;
                JSONObject propertyObject = (JSONObject)v;
                String propertyName = propertyObject.getFieldAsString(JSONFormattedAccessLogFields.SECURITY_NEGOTIATION_PROPERTIES_NAME.getFieldName());
                String propertyValue = propertyObject.getFieldAsString(JSONFormattedAccessLogFields.SECURITY_NEGOTIATION_PROPERTIES_VALUE.getFieldName());
                if (propertyName == null || propertyValue == null) continue;
                propertyMap.put(propertyName, propertyValue);
            }
        }
        this.negotiationProperties = Collections.unmodifiableMap(propertyMap);
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.SECURITY_NEGOTIATION;
    }

    @Override
    @Nullable
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    @Nullable
    public String getCipher() {
        return this.cipher;
    }

    @NotNull
    public Map<String, String> getNegotiationProperties() {
        return this.negotiationProperties;
    }
}

