/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.AddResponseProtocolOp;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.BindResponseProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareResponseProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyDNResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyResponseProtocolOp;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchResultDoneProtocolOp;
import com.unboundid.ldap.protocol.SearchResultEntryProtocolOp;
import com.unboundid.ldap.protocol.SearchResultReferenceProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CannedResponseRequestHandler
extends LDAPListenerRequestHandler
implements Serializable {
    private static final long serialVersionUID = 6199105854736880833L;
    @NotNull
    private final AddResponseProtocolOp addResponseProtocolOp;
    @NotNull
    private final BindResponseProtocolOp bindResponseProtocolOp;
    @NotNull
    private final CompareResponseProtocolOp compareResponseProtocolOp;
    @NotNull
    private final DeleteResponseProtocolOp deleteResponseProtocolOp;
    @NotNull
    private final ExtendedResponseProtocolOp extendedResponseProtocolOp;
    @NotNull
    private final ModifyResponseProtocolOp modifyResponseProtocolOp;
    @NotNull
    private final ModifyDNResponseProtocolOp modifyDNResponseProtocolOp;
    @NotNull
    private final List<SearchResultEntryProtocolOp> searchEntryProtocolOps;
    @NotNull
    private final List<SearchResultReferenceProtocolOp> searchReferenceProtocolOps;
    @NotNull
    private final SearchResultDoneProtocolOp searchResultDoneProtocolOp;
    @Nullable
    private final LDAPListenerClientConnection clientConnection;

    public CannedResponseRequestHandler() {
        this(ResultCode.SUCCESS, null, null, null);
    }

    public CannedResponseRequestHandler(@NotNull ResultCode resultCode, @Nullable String matchedDN, @Nullable String diagnosticMessage, @Nullable List<String> referralURLs) {
        this(resultCode, matchedDN, diagnosticMessage, referralURLs, null, null);
    }

    public CannedResponseRequestHandler(@NotNull ResultCode resultCode, @Nullable String matchedDN, @Nullable String diagnosticMessage, @Nullable List<String> referralURLs, @Nullable Collection<? extends Entry> searchEntries, @Nullable Collection<SearchResultReference> searchReferences) {
        ArrayList<ProtocolOp> l;
        Validator.ensureNotNull(resultCode);
        this.clientConnection = null;
        int rc = resultCode.intValue();
        this.addResponseProtocolOp = new AddResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
        this.bindResponseProtocolOp = new BindResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs, null);
        this.compareResponseProtocolOp = new CompareResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
        this.deleteResponseProtocolOp = new DeleteResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
        this.extendedResponseProtocolOp = new ExtendedResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs, null, null);
        this.modifyResponseProtocolOp = new ModifyResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
        this.modifyDNResponseProtocolOp = new ModifyDNResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
        this.searchResultDoneProtocolOp = new SearchResultDoneProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
        if (searchEntries == null || searchEntries.isEmpty()) {
            this.searchEntryProtocolOps = Collections.emptyList();
        } else {
            l = new ArrayList<ProtocolOp>(searchEntries.size());
            for (Entry entry : searchEntries) {
                l.add(new SearchResultEntryProtocolOp(entry));
            }
            this.searchEntryProtocolOps = Collections.unmodifiableList(l);
        }
        if (searchReferences == null || searchReferences.isEmpty()) {
            this.searchReferenceProtocolOps = Collections.emptyList();
        } else {
            l = new ArrayList(searchReferences.size());
            for (SearchResultReference searchResultReference : searchReferences) {
                l.add(new SearchResultReferenceProtocolOp(searchResultReference));
            }
            this.searchReferenceProtocolOps = Collections.unmodifiableList(l);
        }
    }

    private CannedResponseRequestHandler(@NotNull CannedResponseRequestHandler h, @NotNull LDAPListenerClientConnection c) {
        this.addResponseProtocolOp = h.addResponseProtocolOp;
        this.bindResponseProtocolOp = h.bindResponseProtocolOp;
        this.compareResponseProtocolOp = h.compareResponseProtocolOp;
        this.deleteResponseProtocolOp = h.deleteResponseProtocolOp;
        this.extendedResponseProtocolOp = h.extendedResponseProtocolOp;
        this.modifyResponseProtocolOp = h.modifyResponseProtocolOp;
        this.modifyDNResponseProtocolOp = h.modifyDNResponseProtocolOp;
        this.searchEntryProtocolOps = h.searchEntryProtocolOps;
        this.searchReferenceProtocolOps = h.searchReferenceProtocolOps;
        this.searchResultDoneProtocolOp = h.searchResultDoneProtocolOp;
        this.clientConnection = c;
    }

    @Override
    @NotNull
    public CannedResponseRequestHandler newInstance(@NotNull LDAPListenerClientConnection connection) throws LDAPException {
        return new CannedResponseRequestHandler(this, connection);
    }

    @Override
    @NotNull
    public LDAPMessage processAddRequest(int messageID, @NotNull AddRequestProtocolOp request, @NotNull List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.addResponseProtocolOp, Collections.emptyList());
    }

    @Override
    @NotNull
    public LDAPMessage processBindRequest(int messageID, @NotNull BindRequestProtocolOp request, @NotNull List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.bindResponseProtocolOp, Collections.emptyList());
    }

    @Override
    @NotNull
    public LDAPMessage processCompareRequest(int messageID, @NotNull CompareRequestProtocolOp request, @NotNull List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.compareResponseProtocolOp, Collections.emptyList());
    }

    @Override
    @NotNull
    public LDAPMessage processDeleteRequest(int messageID, @NotNull DeleteRequestProtocolOp request, @NotNull List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.deleteResponseProtocolOp, Collections.emptyList());
    }

    @Override
    @NotNull
    public LDAPMessage processExtendedRequest(int messageID, @NotNull ExtendedRequestProtocolOp request, @NotNull List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.extendedResponseProtocolOp, Collections.emptyList());
    }

    @Override
    @NotNull
    public LDAPMessage processModifyRequest(int messageID, @NotNull ModifyRequestProtocolOp request, @NotNull List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.modifyResponseProtocolOp, Collections.emptyList());
    }

    @Override
    @NotNull
    public LDAPMessage processModifyDNRequest(int messageID, @NotNull ModifyDNRequestProtocolOp request, @NotNull List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.modifyDNResponseProtocolOp, Collections.emptyList());
    }

    @Override
    @NotNull
    public LDAPMessage processSearchRequest(int messageID, @NotNull SearchRequestProtocolOp request, @NotNull List<Control> controls) {
        for (SearchResultEntryProtocolOp e : this.searchEntryProtocolOps) {
            try {
                this.clientConnection.sendSearchResultEntry(messageID, e, new Control[0]);
            }
            catch (Exception ex) {
                Debug.debugException(ex);
            }
        }
        for (SearchResultReferenceProtocolOp r : this.searchReferenceProtocolOps) {
            try {
                this.clientConnection.sendSearchResultReference(messageID, r, new Control[0]);
            }
            catch (Exception ex) {
                Debug.debugException(ex);
            }
        }
        return new LDAPMessage(messageID, (ProtocolOp)this.searchResultDoneProtocolOp, Collections.emptyList());
    }
}

