/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.processor;

import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.ParsingContextWrapper;
import com.univocity.parsers.common.processor.RowProcessor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ConcurrentRowProcessor
implements RowProcessor {
    private final RowProcessor rowProcessor;
    private boolean ended = false;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private long rowCount;
    private Future<Void> process;
    private ParsingContext context;
    private Node inputQueue;
    private volatile Node outputQueue;

    public ConcurrentRowProcessor(RowProcessor rowProcessor) {
        if (rowProcessor == null) {
            throw new IllegalArgumentException("Row processor cannot be null");
        }
        this.rowProcessor = rowProcessor;
    }

    @Override
    public final void processStarted(ParsingContext context) {
        this.rowProcessor.processStarted(context);
        this.context = new ParsingContextWrapper(context){

            @Override
            public long currentRecord() {
                return ConcurrentRowProcessor.this.rowCount;
            }
        };
        this.startProcess();
    }

    private void startProcess() {
        this.ended = false;
        this.rowCount = 0L;
        this.process = this.executor.submit(new Callable<Void>(){

            @Override
            public Void call() {
                while (ConcurrentRowProcessor.this.outputQueue == null && !ConcurrentRowProcessor.this.ended) {
                    Thread.yield();
                }
                while (!ConcurrentRowProcessor.this.ended) {
                    ConcurrentRowProcessor.this.rowCount++;
                    ConcurrentRowProcessor.this.rowProcessor.rowProcessed(((ConcurrentRowProcessor)ConcurrentRowProcessor.this).outputQueue.row, ConcurrentRowProcessor.this.context);
                    while (((ConcurrentRowProcessor)ConcurrentRowProcessor.this).outputQueue.next == null) {
                        if (!ConcurrentRowProcessor.this.ended || ((ConcurrentRowProcessor)ConcurrentRowProcessor.this).outputQueue.next != null) continue;
                        return null;
                    }
                    ConcurrentRowProcessor.this.outputQueue = ((ConcurrentRowProcessor)ConcurrentRowProcessor.this).outputQueue.next;
                }
                while (ConcurrentRowProcessor.this.outputQueue != null) {
                    ConcurrentRowProcessor.this.rowCount++;
                    ConcurrentRowProcessor.this.rowProcessor.rowProcessed(((ConcurrentRowProcessor)ConcurrentRowProcessor.this).outputQueue.row, ConcurrentRowProcessor.this.context);
                    ConcurrentRowProcessor.this.outputQueue = ((ConcurrentRowProcessor)ConcurrentRowProcessor.this).outputQueue.next;
                }
                return null;
            }
        });
    }

    @Override
    public final void rowProcessed(String[] row, ParsingContext context) {
        if (this.inputQueue == null) {
            this.outputQueue = this.inputQueue = new Node(row);
        } else {
            this.inputQueue = this.inputQueue.next = new Node(row);
        }
    }

    @Override
    public final void processEnded(ParsingContext context) {
        this.rowProcessor.processEnded(context);
        this.ended = true;
        try {
            this.process.get();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Error executing process", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Process interrupted", e);
        }
    }

    private class Node {
        public final String[] row;
        public Node next;

        public Node(String[] row) {
            this.row = row;
        }
    }
}

