/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.conversions;

import com.univocity.parsers.conversions.BigDecimalConversion;
import com.univocity.parsers.conversions.BigIntegerConversion;
import com.univocity.parsers.conversions.BooleanConversion;
import com.univocity.parsers.conversions.ByteConversion;
import com.univocity.parsers.conversions.CalendarConversion;
import com.univocity.parsers.conversions.CharacterConversion;
import com.univocity.parsers.conversions.DateConversion;
import com.univocity.parsers.conversions.DoubleConversion;
import com.univocity.parsers.conversions.EnumConversion;
import com.univocity.parsers.conversions.EnumSelector;
import com.univocity.parsers.conversions.FloatConversion;
import com.univocity.parsers.conversions.FormattedBigDecimalConversion;
import com.univocity.parsers.conversions.IntegerConversion;
import com.univocity.parsers.conversions.LongConversion;
import com.univocity.parsers.conversions.LowerCaseConversion;
import com.univocity.parsers.conversions.NullStringConversion;
import com.univocity.parsers.conversions.NumericConversion;
import com.univocity.parsers.conversions.RegexConversion;
import com.univocity.parsers.conversions.ShortConversion;
import com.univocity.parsers.conversions.TrimConversion;
import com.univocity.parsers.conversions.UpperCaseConversion;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;

public class Conversions {
    private static final UpperCaseConversion upperCase = new UpperCaseConversion();
    private static final LowerCaseConversion lowerCase = new LowerCaseConversion();
    private static final TrimConversion trim = new TrimConversion();

    private Conversions() {
    }

    public static UpperCaseConversion toUpperCase() {
        return upperCase;
    }

    public static LowerCaseConversion toLowerCase() {
        return lowerCase;
    }

    public static TrimConversion trim() {
        return trim;
    }

    public static RegexConversion replace(String replaceRegex, String replacement) {
        return new RegexConversion(replaceRegex, replacement);
    }

    public static NullStringConversion toNull(String ... nullRepresentations) {
        return new NullStringConversion(nullRepresentations);
    }

    public static DateConversion toDate(String ... dateFormats) {
        return new DateConversion(dateFormats);
    }

    public static DateConversion toDate(Date dateIfNull, String ... dateFormats) {
        return new DateConversion(dateIfNull, null, dateFormats);
    }

    public static DateConversion toDate(Date dateIfNull, String stringIfNull, String ... dateFormats) {
        return new DateConversion(dateIfNull, stringIfNull, dateFormats);
    }

    public static CalendarConversion toCalendar(String ... dateFormats) {
        return new CalendarConversion(dateFormats);
    }

    public static CalendarConversion toCalendar(Calendar dateIfNull, String ... dateFormats) {
        return new CalendarConversion(dateIfNull, null, dateFormats);
    }

    public static CalendarConversion toCalendar(Calendar dateIfNull, String stringIfNull, String ... dateFormats) {
        return new CalendarConversion(dateIfNull, stringIfNull, dateFormats);
    }

    public static ByteConversion toByte() {
        return new ByteConversion();
    }

    public static ShortConversion toShort() {
        return new ShortConversion();
    }

    public static IntegerConversion toInteger() {
        return new IntegerConversion();
    }

    public static LongConversion toLong() {
        return new LongConversion();
    }

    public static BigIntegerConversion toBigInteger() {
        return new BigIntegerConversion();
    }

    public static FloatConversion toFloat() {
        return new FloatConversion();
    }

    public static DoubleConversion toDouble() {
        return new DoubleConversion();
    }

    public static BigDecimalConversion toBigDecimal() {
        return new BigDecimalConversion();
    }

    public static NumericConversion<Number> formatToNumber(String ... numberFormats) {
        return new NumericConversion<Number>(numberFormats){

            @Override
            protected void configureFormatter(DecimalFormat formatter) {
            }
        };
    }

    public static FormattedBigDecimalConversion formatToBigDecimal(String ... numberFormats) {
        return new FormattedBigDecimalConversion(numberFormats);
    }

    public static FormattedBigDecimalConversion formatToBigDecimal(BigDecimal defaultValueForNullString, String ... numberFormats) {
        return new FormattedBigDecimalConversion(defaultValueForNullString, null, numberFormats);
    }

    public static FormattedBigDecimalConversion formatToBigDecimal(BigDecimal defaultValueForNullString, String stringIfNull, String ... numberFormats) {
        return new FormattedBigDecimalConversion(defaultValueForNullString, stringIfNull, numberFormats);
    }

    public static BooleanConversion toBoolean(Boolean defaultValueForNullString, String defaultValueForNullBoolean, String[] valuesForTrue, String[] valuesForFalse) {
        return new BooleanConversion(defaultValueForNullString, defaultValueForNullBoolean, valuesForTrue, valuesForFalse);
    }

    public static BooleanConversion toBoolean(String[] valuesForTrue, String[] valuesForFalse) {
        return new BooleanConversion(valuesForTrue, valuesForFalse);
    }

    public static BooleanConversion toBoolean() {
        return Conversions.toBoolean("true", "false");
    }

    public static BooleanConversion toBoolean(String valueForTrue, String valueForFalse) {
        return new BooleanConversion(new String[]{valueForTrue}, new String[]{valueForFalse});
    }

    public static CharacterConversion toChar() {
        return new CharacterConversion();
    }

    public static CharacterConversion toChar(Character defaultValueForNullString, String defaultValueForNullChar) {
        return new CharacterConversion(defaultValueForNullString, defaultValueForNullChar);
    }

    public static CharacterConversion toChar(Character defaultValueForNullString) {
        return new CharacterConversion(defaultValueForNullString, null);
    }

    public static <T extends Enum<T>> EnumConversion<T> toEnum(Class<T> enumType) {
        return new EnumConversion<T>(enumType);
    }

    public <T extends Enum<T>> EnumConversion<T> toEnum(Class<T> enumType, EnumSelector ... selectors) {
        return this.toEnum(enumType, (T)null, (String)null, (String)null, selectors);
    }

    public <T extends Enum<T>> EnumConversion<T> toEnum(Class<T> enumType, String customEnumElement, EnumSelector ... selectors) {
        return this.toEnum(enumType, null, null, customEnumElement, new EnumSelector[0]);
    }

    public <T extends Enum<T>> EnumConversion<T> toEnum(Class<T> enumType, T valueIfStringIsNull, String valueIfEnumIsNull, String customEnumElement, EnumSelector ... selectors) {
        return new EnumConversion<T>(enumType, valueIfStringIsNull, valueIfEnumIsNull, customEnumElement, selectors);
    }
}

