package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.IdeIntegration;
import com.vaadin.base.devserver.OpenInCurrentIde;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import elemental.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.Optional;

public class OpenComponentInIDE implements CopilotCommand {

    IdeIntegration ideIntegration;

    public OpenComponentInIDE(
            ApplicationConfiguration applicationConfiguration) {
        this.ideIntegration = new IdeIntegration(applicationConfiguration);
    }

    @Override
    public boolean handleMessage(String command, JsonObject data,
            DevToolsInterface devToolsInterface) {
        if (command.equals("show-component")) {
            if (data.hasKey("nodeId")) {
                showFlowComponent((int) data.getNumber("uiId"),
                        (int) data.getNumber("nodeId"));
            } else {
                showReactComponent(data.getString("fileName"),
                        (int) data.getNumber("lineNumber"));
            }
            return true;
        }
        return false;
    }

    public void showFlowComponent(int uiId, int nodeId) {
        VaadinSession session = VaadinSession.getCurrent();
        session.access(() -> {
            Element element = session.findElement(uiId, nodeId);
            Optional<Component> c = element.getComponent();
            if (c.isPresent()) {
                ideIntegration.showComponentCreateInIde(c.get());
            } else {
                getLogger().error(
                        "Only component locations are tracked. The given node id refers to an element and not a component");
            }
        });
    }

    public void showReactComponent(String filename, int lineNumber) {
        File file = new File(filename);
        OpenInCurrentIde.openFile(file, lineNumber);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(getClass());
    }

}
