package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import elemental.json.Json;
import elemental.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

public class ProjectFileHandler implements CopilotCommand {

    private final ProjectManager projectManager;

    public ProjectFileHandler(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    @Override
    public boolean handleMessage(String command, JsonObject data,
            DevToolsInterface devToolsInterface) {
        if (command.equals("get-project-file")) {
            String filename = data.getString("filename");
            String reqId = data.getString(KEY_REQ_ID);

            JsonObject responseData = Json.createObject();
            responseData.put(KEY_REQ_ID, reqId);
            try {
                responseData.put("content", projectManager.readFile(filename));
                devToolsInterface.send(Copilot.PREFIX + "project-file",
                        responseData);
            } catch (IOException e) {
                responseData.put("error", true);
                devToolsInterface.send(Copilot.PREFIX + "project-file",
                        responseData);
                getLogger().error("Unable to read project file {}", filename,
                        e);
            }
            return true;
        } else if (command.equals("write-project-file")) {
            String filename = data.getString("filename");
            String reqId = data.getString(KEY_REQ_ID);
            String content = data.getString("content");
            JsonObject responseData = Json.createObject();
            responseData.put(KEY_REQ_ID, reqId);
            try {
                projectManager.writeFile(filename, content);
                devToolsInterface.send(Copilot.PREFIX + "project-file-written",
                        responseData);
            } catch (IOException e) {
                responseData.put("error", true);
                devToolsInterface.send(Copilot.PREFIX + "project-file-written",
                        responseData);
                getLogger().error("Unable to write project file {}", filename,
                        e);
            }
            return true;
        }

        return false;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(getClass());
    }
}
