package com.vaadin.copilot.analytics;

import com.vaadin.copilot.CopilotServerClient;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.ProKey;

import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;

/**
 * Client for tracking features of Copilot
 */
public class AnalyticsClient extends CopilotServerClient {

    private final ProKey proKey;

    private final String machineId;

    /**
     * Constructor loading ProKey
     */
    public AnalyticsClient() {
        this.proKey = LocalProKey.get();
        this.machineId = MachineId.get();
    }

    /**
     * Track event to copilot-server
     *
     * @param event
     *            Event name
     * @param properties
     *            Map of event properties
     */
    public void track(String event, Map<String, Object> properties) {
        sendRequest(event, properties);
    }

    protected void sendRequest(String event, Map<String, Object> properties) {
        URI uri = getQueryURI("analytics");
        AnalyticsRequest trackingRequest = new AnalyticsRequest(
                proKey != null ? proKey.getProKey() : null, machineId, event,
                properties);
        String json = writeAsJsonString(trackingRequest);
        HttpRequest request = buildRequest(uri, json);
        getHttpClient().sendAsync(request,
                HttpResponse.BodyHandlers.ofString());
    }

}
