/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.util.LinkedList;
import java.util.List;
import org.atmosphere.container.BlockingIOCometSupport;
import org.atmosphere.container.GlassFishServ30WebSocketSupport;
import org.atmosphere.container.GlassFishWebSocketSupport;
import org.atmosphere.container.GlassFishv2CometSupport;
import org.atmosphere.container.Grizzly2CometSupport;
import org.atmosphere.container.Grizzly2WebSocketSupport;
import org.atmosphere.container.GrizzlyCometSupport;
import org.atmosphere.container.GrizzlyServlet30WebSocketSupport;
import org.atmosphere.container.JBossAsyncSupportWithWebSocket;
import org.atmosphere.container.JBossWebCometSupport;
import org.atmosphere.container.JSR356AsyncSupport;
import org.atmosphere.container.Jetty7CometSupport;
import org.atmosphere.container.Jetty93AsyncSupportWithWebSocket;
import org.atmosphere.container.Jetty9AsyncSupportWithWebSocket;
import org.atmosphere.container.JettyAsyncSupportWithWebSocket;
import org.atmosphere.container.JettyCometSupport;
import org.atmosphere.container.JettyServlet30AsyncSupportWithWebSocket;
import org.atmosphere.container.NettyCometSupport;
import org.atmosphere.container.Servlet30CometSupport;
import org.atmosphere.container.Tomcat7AsyncSupportWithWebSocket;
import org.atmosphere.container.Tomcat7CometSupport;
import org.atmosphere.container.Tomcat7Servlet30SupportWithWebSocket;
import org.atmosphere.container.TomcatCometSupport;
import org.atmosphere.container.WebLogicServlet30WithWebSocket;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsyncSupportResolver;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.util.IOUtils;

public class DefaultAsyncSupportResolver
implements AsyncSupportResolver {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAsyncSupportResolver.class);
    public static final String SERVLET_30 = "javax.servlet.AsyncListener";
    public static final String GLASSFISH_V2 = "com.sun.enterprise.web.PEWebContainer";
    public static final String TOMCAT_7 = "org.apache.catalina.comet.CometFilterChain";
    public static final String TOMCAT_WEBSOCKET = "org.apache.coyote.http11.upgrade.UpgradeInbound";
    public static final String TOMCAT = "org.apache.coyote.http11.Http11NioProcessor";
    public static final String JBOSS_5 = "org.jboss.";
    public static final String JETTY = "org.mortbay.util.ajax.Continuation";
    public static final String JETTY_7 = "org.eclipse.jetty.servlet.ServletContextHandler";
    public static final String JETTY_8 = "org.eclipse.jetty.continuation.Servlet3Continuation";
    public static final String JETTY_9 = "org.eclipse.jetty.websocket.api.WebSocketPolicy";
    public static final String GRIZZLY = "com.sun.grizzly.http.servlet.ServletAdapter";
    public static final String GRIZZLY2 = "org.glassfish.grizzly.http.servlet.ServletHandler";
    public static final String JBOSSWEB = "org.apache.catalina.connector.HttpEventImpl";
    public static final String GRIZZLY_WEBSOCKET = "com.sun.grizzly.websockets.WebSocketEngine";
    public static final String GRIZZLY2_WEBSOCKET = "org.glassfish.grizzly.websockets.WebSocketEngine";
    public static final String NETTY = "org.jboss.netty.channel.Channel";
    public static final String JBOSS_AS7_WEBSOCKET = "org.atmosphere.jboss.as.websockets.servlet.WebSocketServlet";
    public static final String JSR356_WEBSOCKET = "javax.websocket.Endpoint";
    public static final String WEBLOGIC_WEBSOCKET = "weblogic.websocket.annotation.WebSocket";
    public static final String HK2 = "org.glassfish.hk2.utilities.reflection.ReflectionHelper";
    private final AtmosphereConfig config;
    private final boolean suppress356;

    public DefaultAsyncSupportResolver(AtmosphereConfig config) {
        this.config = config;
        this.suppress356 = Boolean.parseBoolean(config.getInitParameter("org.atmosphere.websocket.suppressJSR356"));
    }

    protected boolean testClassExists(String testClass) {
        try {
            boolean exists = testClass != null && testClass.length() > 0 && IOUtils.loadClass(null, testClass) != null;
            logger.debug(exists ? "Found {}" : "Not found {}", (Object)testClass);
            return exists;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public List<Class<? extends AsyncSupport>> detectContainersPresent() {
        return new LinkedList<Class<? extends AsyncSupport>>(){
            {
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.GLASSFISH_V2)) {
                    this.add(GlassFishv2CometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JETTY_9)) {
                    this.add(Jetty7CometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JETTY_8)) {
                    this.add(Jetty7CometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JETTY_7)) {
                    this.add(Jetty7CometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JETTY)) {
                    this.add(JettyCometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JBOSSWEB)) {
                    this.add(JBossWebCometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.TOMCAT_7)) {
                    this.add(Tomcat7CometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.TOMCAT) || DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JBOSS_5)) {
                    this.add(TomcatCometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.GRIZZLY)) {
                    this.add(GrizzlyCometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.GRIZZLY2)) {
                    this.add(Grizzly2CometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.NETTY)) {
                    this.add(NettyCometSupport.class);
                }
            }
        };
    }

    public List<Class<? extends AsyncSupport>> detectWebSocketPresent(final boolean useNativeIfPossible, final boolean useServlet30Async) {
        return new LinkedList<Class<? extends AsyncSupport>>(){
            {
                if (useServlet30Async && !useNativeIfPossible) {
                    if (!DefaultAsyncSupportResolver.this.suppress356 && DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JSR356_WEBSOCKET)) {
                        this.add(JSR356AsyncSupport.class);
                    } else {
                        if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.TOMCAT_WEBSOCKET)) {
                            this.add(Tomcat7Servlet30SupportWithWebSocket.class);
                        }
                        if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JETTY_9)) {
                            this.add(Jetty9AsyncSupportWithWebSocket.class);
                            this.add(Jetty93AsyncSupportWithWebSocket.class);
                        }
                        if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JETTY_8)) {
                            this.add(JettyServlet30AsyncSupportWithWebSocket.class);
                        }
                        if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.GRIZZLY2_WEBSOCKET)) {
                            this.add(GlassFishServ30WebSocketSupport.class);
                        }
                        if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.GRIZZLY_WEBSOCKET)) {
                            this.add(GrizzlyServlet30WebSocketSupport.class);
                        }
                        if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.WEBLOGIC_WEBSOCKET) && !DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.HK2)) {
                            logger.warn("***************************************************************************************************");
                            logger.warn("WebLogic WebSocket detected and will be deployed under the hardcoded path <<application-name>>/ws/*");
                            logger.warn("***************************************************************************************************");
                            this.add(WebLogicServlet30WithWebSocket.class);
                        }
                    }
                } else if (!DefaultAsyncSupportResolver.this.suppress356 && DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JSR356_WEBSOCKET)) {
                    this.add(JSR356AsyncSupport.class);
                } else {
                    if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.TOMCAT_WEBSOCKET)) {
                        this.add(Tomcat7AsyncSupportWithWebSocket.class);
                    }
                    if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JETTY_9)) {
                        this.add(Jetty9AsyncSupportWithWebSocket.class);
                    }
                    if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JETTY_8)) {
                        this.add(JettyAsyncSupportWithWebSocket.class);
                    }
                    if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.GRIZZLY_WEBSOCKET)) {
                        this.add(GlassFishWebSocketSupport.class);
                    }
                    if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.GRIZZLY2_WEBSOCKET)) {
                        this.add(Grizzly2WebSocketSupport.class);
                    }
                    if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JBOSS_AS7_WEBSOCKET)) {
                        this.add(JBossAsyncSupportWithWebSocket.class);
                    }
                }
            }
        };
    }

    public AsyncSupport defaultCometSupport(boolean preferBlocking) {
        if (!preferBlocking && this.testClassExists(SERVLET_30)) {
            return new Servlet30CometSupport(this.config);
        }
        return new BlockingIOCometSupport(this.config);
    }

    public AsyncSupport newCometSupport(Class<? extends AsyncSupport> targetClass) {
        try {
            return targetClass.getDeclaredConstructor(AtmosphereConfig.class).newInstance(this.config);
        }
        catch (Exception e) {
            logger.warn("Failed to create AsyncSupport class: {}, error: {}", targetClass, (Object)e);
            Throwable cause = e.getCause();
            if (cause != null) {
                logger.error("Real error: {}", (Object)cause.getMessage(), (Object)cause);
            }
            return null;
        }
    }

    public AsyncSupport newCometSupport(String targetClassFQN) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return (AsyncSupport)cl.loadClass(targetClassFQN).getDeclaredConstructor(AtmosphereConfig.class).newInstance(this.config);
        }
        catch (Exception e) {
            logger.error("Failed to create AsyncSupport class: {}, error: {}", (Object)targetClassFQN, (Object)e);
            Throwable cause = e.getCause();
            if (cause != null) {
                logger.error("Real error: {}", (Object)cause.getMessage(), (Object)cause);
            }
            throw new IllegalArgumentException("Unable to create " + targetClassFQN, e);
        }
    }

    public AsyncSupport resolve(boolean useNativeIfPossible, boolean defaultToBlocking) {
        AsyncSupport servletAsyncSupport = this.defaultCometSupport(defaultToBlocking);
        if (!defaultToBlocking && (useNativeIfPossible || servletAsyncSupport.getClass().getName().equals(BlockingIOCometSupport.class.getName()))) {
            AsyncSupport nativeSupport = this.resolveNativeCometSupport(this.detectContainersPresent());
            return nativeSupport == null ? servletAsyncSupport : nativeSupport;
        }
        return servletAsyncSupport;
    }

    @Override
    public AsyncSupport resolve(boolean useNativeIfPossible, boolean defaultToBlocking, boolean useServlet30Async) {
        List<Class<? extends AsyncSupport>> l;
        AsyncSupport cs = null;
        useServlet30Async = this.testClassExists(SERVLET_30);
        if (!defaultToBlocking && !(l = this.detectWebSocketPresent(useNativeIfPossible, useServlet30Async)).isEmpty()) {
            cs = this.resolveWebSocket(l);
        }
        if (cs == null) {
            AsyncSupport nativeSupport = this.resolveNativeCometSupport(this.detectContainersPresent());
            return nativeSupport == null ? this.defaultCometSupport(defaultToBlocking) : nativeSupport;
        }
        return cs;
    }

    public AsyncSupport resolveWebSocket(List<Class<? extends AsyncSupport>> available) {
        if (available == null || available.isEmpty()) {
            return null;
        }
        return this.newCometSupport(available.get(0));
    }

    protected AsyncSupport resolveNativeCometSupport(List<Class<? extends AsyncSupport>> available) {
        if (available == null || available.isEmpty()) {
            return null;
        }
        if (available.size() == 1) {
            return this.newCometSupport(available.get(0));
        }
        return this.resolveMultipleNativeSupportConflict(available);
    }

    protected AsyncSupport resolveMultipleNativeSupportConflict(List<Class<? extends AsyncSupport>> available) {
        StringBuilder b = new StringBuilder("Found multiple containers, please specify which one to use: ");
        for (Class<? extends AsyncSupport> cs : available) {
            b.append(cs != null ? cs.getCanonicalName() : "null").append(", ");
        }
        b.append(" until you do, Atmosphere will use:" + available.get(0));
        logger.warn("{}", (Object)b.toString());
        return this.newCometSupport(available.get(0));
    }
}

