/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util.analytics;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Random;
import org.atmosphere.util.analytics.FocusPoint;
import org.atmosphere.util.analytics.URLBuildingStrategy;

public class GoogleAnalytics_v1_URLBuildingStrategy
implements URLBuildingStrategy {
    private FocusPoint appFocusPoint;
    private String googleAnalyticsTrackingCode;
    private String refererURL = "http://async-io.org";
    private static final String TRACKING_URL_Prefix = "http://www.google-analytics.com/__utm.gif";
    private static final Random random = new Random();
    private static String hostName = "localhost";

    public GoogleAnalytics_v1_URLBuildingStrategy(String appName, String googleAnalyticsTrackingCode) {
        this.googleAnalyticsTrackingCode = googleAnalyticsTrackingCode;
        this.appFocusPoint = new FocusPoint(appName);
    }

    public GoogleAnalytics_v1_URLBuildingStrategy(String appName, String appVersion, String googleAnalyticsTrackingCode) {
        this.googleAnalyticsTrackingCode = googleAnalyticsTrackingCode;
        this.appFocusPoint = new FocusPoint(appVersion, new FocusPoint(appName));
    }

    @Override
    public String buildURL(FocusPoint focusPoint) {
        int cookie = random.nextInt();
        int randomValue = random.nextInt(Integer.MAX_VALUE) - 1;
        long now = new Date().getTime();
        focusPoint.setParentTrackPoint(this.appFocusPoint);
        StringBuffer url = new StringBuffer(TRACKING_URL_Prefix);
        url.append("?utmwv=1");
        url.append("&utmn=" + random.nextInt());
        url.append("&utmcs=UTF-8");
        url.append("&utmsr=1440x900");
        url.append("&utmsc=32-bit");
        url.append("&utmul=en-us");
        url.append("&utmje=1");
        url.append("&utmfl=9.0%20%20r28");
        url.append("&utmcr=1");
        url.append("&utmdt=" + focusPoint.getContentTitle());
        url.append("&utmhn=" + hostName);
        url.append("&utmr=" + this.refererURL);
        url.append("&utmp=" + focusPoint.getContentURI());
        url.append("&utmac=" + this.googleAnalyticsTrackingCode);
        url.append("&utmcc=__utma%3D'" + cookie + "." + randomValue + "." + now + "." + now + "." + now + ".2%3B%2B__utmb%3D" + cookie + "%3B%2B__utmc%3D" + cookie + "%3B%2B__utmz%3D" + cookie + "." + now + ".2.2.utmccn%3D(direct)%7Cutmcsr%3D(direct)%7Cutmcmd%3D(none)%3B%2B__utmv%3D" + cookie);
        return url.toString();
    }

    @Override
    public void setRefererURL(String refererURL) {
        this.refererURL = refererURL;
    }

    static {
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

