/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.ErrorMessageProvider;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import java.io.Serializable;
import java.util.UUID;
import org.slf4j.LoggerFactory;

public class StringToUuidConverter
implements Converter<String, UUID> {
    private ErrorMessageProvider errorMessageProvider;

    public StringToUuidConverter(String errorMessage) {
        this((ErrorMessageProvider & Serializable)(ValueContext ctx) -> errorMessage);
    }

    public StringToUuidConverter(ErrorMessageProvider errorMessageProvider) {
        this.errorMessageProvider = errorMessageProvider;
    }

    @Override
    public Result<UUID> convertToModel(String value, ValueContext context) {
        if (value == null) {
            return Result.ok(null);
        }
        value = value.trim();
        UUID uuid = null;
        try {
            uuid = UUID.fromString(value);
        }
        catch (IllegalArgumentException e) {
            LoggerFactory.getLogger((String)StringToUuidConverter.class.getName()).warn("Unable to convert String to UUID: " + value, (Throwable)e);
            return Result.error(this.errorMessageProvider.apply(context));
        }
        return Result.ok(uuid);
    }

    @Override
    public String convertToPresentation(UUID value, ValueContext context) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

