/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.webcomponent.WebComponentConfiguration;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.SynchronizedRequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.webcomponent.WebComponentConfigurationRegistry;
import com.vaadin.flow.server.webcomponent.WebComponentGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;

public class WebComponentProvider
extends SynchronizedRequestHandler {
    private static final String WEB_COMPONENT_PATH = "web-component/";
    private static final String PATH_PREFIX = "/web-component/";
    private static final String HTML_EXTENSION = "html";
    private static final String JS_EXTENSION = "js";
    private static final Pattern TAG_PATTERN = Pattern.compile(".*/(([\\w&&[^_]]+-)+([\\w&&[^_]]+))\\.(js|html)$");
    private Map<String, String> cache = new HashMap<String, String>();

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.isEmpty()) {
            return false;
        }
        return pathInfo.startsWith(PATH_PREFIX);
    }

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        String pathInfo = request.getPathInfo();
        boolean compatibilityMode = session.getService().getDeploymentConfiguration().isCompatibilityMode();
        ComponentInfo componentInfo = new ComponentInfo(pathInfo);
        if (!componentInfo.hasExtension()) {
            LoggerFactory.getLogger(WebComponentProvider.class).info("Received web-component request without extension information (.js/.html) with request path {}", (Object)pathInfo);
            return false;
        }
        if (componentInfo.getTag() == null) {
            LoggerFactory.getLogger(WebComponentProvider.class).info("Received web-component request for non-custom element with request path {}", (Object)pathInfo);
            return false;
        }
        if (componentInfo.isHTML() && !compatibilityMode) {
            LoggerFactory.getLogger(WebComponentProvider.class).info("Received web-component request for html component in npm mode with request path {}", (Object)pathInfo);
            return false;
        }
        if (componentInfo.isJS() && compatibilityMode) {
            LoggerFactory.getLogger(WebComponentProvider.class).info("Received web-component request for js component in compatibility mode with request path {}", (Object)pathInfo);
            return false;
        }
        WebComponentConfigurationRegistry registry = WebComponentConfigurationRegistry.getInstance(request.getService().getContext());
        Optional<WebComponentConfiguration<? extends Component>> optionalWebComponentConfiguration = registry.getConfiguration(componentInfo.tag);
        if (optionalWebComponentConfiguration.isPresent()) {
            Supplier<String> responder;
            WebComponentConfiguration<? extends Component> webComponentConfiguration = optionalWebComponentConfiguration.get();
            if (compatibilityMode) {
                responder = () -> this.generateBowerResponse(webComponentConfiguration, session, request, response);
            } else {
                response.setContentType("text/javascript; charset=utf-8");
                responder = () -> this.generateNPMResponse(webComponentConfiguration.getTag(), request, response);
            }
            String generated = this.cache == null ? responder.get() : this.cache.computeIfAbsent(componentInfo.tag, moduleTag -> (String)responder.get());
            IOUtils.write((String)generated, (OutputStream)response.getOutputStream(), (Charset)StandardCharsets.UTF_8);
        } else {
            response.sendError(404, "No web component for " + Optional.ofNullable(componentInfo.tag).orElse("<null>"));
        }
        return true;
    }

    public boolean isCacheEnabled() {
        return this.cache != null;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cache = cacheEnabled ? new HashMap<String, String>() : null;
    }

    private String generateBowerResponse(WebComponentConfiguration<? extends Component> configuration, VaadinSession session, VaadinRequest request, VaadinResponse response) {
        if (session.getConfiguration().useCompiledFrontendResources()) {
            response.setContentType("text/javascript; charset=utf-8");
            return this.generateCompiledUIDeclaration(session, request, configuration.getTag());
        }
        response.setContentType("text/html; charset=utf-8");
        return WebComponentGenerator.generateModule(configuration, WebComponentProvider.getFrontendPath(request), true);
    }

    private String generateCompiledUIDeclaration(VaadinSession session, VaadinRequest request, String tagName) {
        String contextRootRelativePath = request.getService().getContextRootRelativePath(request);
        BootstrapHandler.BootstrapUriResolver resolver = new BootstrapHandler.BootstrapUriResolver(contextRootRelativePath, session);
        String polyFillsUri = resolver.resolveVaadinUri("frontend://bower_components/webcomponentsjs/webcomponents-loader.js");
        return WebComponentProvider.getThisScript(tagName) + this.generateAddPolyfillsScript(polyFillsUri, "thisScript") + this.generateUiImport("thisScript");
    }

    private String generateAddPolyfillsScript(String polyFillsUri, String jsParentRef) {
        return "var scriptUri = " + jsParentRef + ".src;var indx = scriptUri.lastIndexOf('" + WEB_COMPONENT_PATH + "');var embeddedWebApp = scriptUri.substring(0, indx);var js = document.createElement('script');js.setAttribute('type','text/javascript');js.setAttribute('src', embeddedWebApp+'" + polyFillsUri + "');document.head.insertBefore(js, " + jsParentRef + ".nextSibling);";
    }

    private String generateUiImport(String jsParentRef) {
        return "var scriptUri = " + jsParentRef + ".src;var indx = scriptUri.lastIndexOf('" + WEB_COMPONENT_PATH + "');var uiUri = scriptUri.substring(0, indx+" + WEB_COMPONENT_PATH.length() + ");var link = document.createElement('link');link.setAttribute('rel','import');link.setAttribute('href', uiUri+'web-component-ui.html');document.head.insertBefore(link, " + jsParentRef + ".nextSibling);";
    }

    protected String generateNPMResponse(String tagName, VaadinRequest request, VaadinResponse response) {
        return WebComponentProvider.getThisScript(tagName) + "var scriptUri = thisScript.src;var index = scriptUri.lastIndexOf('" + WEB_COMPONENT_PATH + "');var context = scriptUri.substring(0, index+" + WEB_COMPONENT_PATH.length() + ");var bootstrapAddress=context+'web-component-bootstrap.js';" + this.bootstrapNpm();
    }

    protected String bootstrapNpm() {
        return "var bootstrapped = false;\nbootstrapAddress+='?url='+bootstrapAddress;var scripts = document.getElementsByTagName('script');for (var ii = 0; ii < scripts.length; ii++){  if (scripts[ii].src === bootstrapAddress){    bootstrapped=true; break;  }}if (!bootstrapped){  var uiScript = document.createElement('script');  uiScript.setAttribute('type','text/javascript');  uiScript.setAttribute('src', bootstrapAddress);  document.head.appendChild(uiScript);}";
    }

    private static String getFrontendPath(VaadinRequest request) {
        if (request == null) {
            return null;
        }
        String contextPath = request.getContextPath();
        if (contextPath.isEmpty()) {
            return "/frontend/";
        }
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        if (contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        return contextPath + "/frontend/";
    }

    private static String getThisScript(String tag) {
        return "var thisScript;if (document.currentScript) {  thisScript = document.currentScript;} else {  var elements = document.getElementsByTagName('script');  for (var ii = 0; ii < elements.length; ii++) {    var script = elements[ii];    if (script.src && script.src.indexOf('web-component/" + tag + "') != -1) {      thisScript = script;    }  };} ";
    }

    private static class ComponentInfo
    implements Serializable {
        final String tag;
        final String extension;

        private ComponentInfo(String pathInfo) {
            Matcher matcher = TAG_PATTERN.matcher(pathInfo);
            if (matcher.find()) {
                this.tag = matcher.group(1);
                this.extension = matcher.group(4);
            } else {
                this.tag = null;
                this.extension = null;
            }
        }

        String getTag() {
            return this.tag;
        }

        boolean hasExtension() {
            return this.extension != null;
        }

        boolean isHTML() {
            return WebComponentProvider.HTML_EXTENSION.equals(this.extension);
        }

        boolean isJS() {
            return WebComponentProvider.JS_EXTENSION.equals(this.extension);
        }
    }
}

