/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.Inline;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.BootstrapHandlerHelper;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.UsageStatisticsExporter;
import com.vaadin.flow.router.InvalidLocationException;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.LocationUtil;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.BootstrapException;
import com.vaadin.flow.server.BootstrapUtils;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.InlineTargets;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.PwaIcon;
import com.vaadin.flow.server.PwaRegistry;
import com.vaadin.flow.server.SynchronizedRequestHandler;
import com.vaadin.flow.server.SystemMessages;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.Version;
import com.vaadin.flow.server.communication.AtmospherePushConnection;
import com.vaadin.flow.server.communication.IndexHtmlRequestHandler;
import com.vaadin.flow.server.communication.PushConnectionFactory;
import com.vaadin.flow.server.communication.UidlWriter;
import com.vaadin.flow.server.frontend.CssBundler;
import com.vaadin.flow.server.frontend.DevBundleUtils;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.ThemeUtils;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.shared.VaadinUriResolver;
import com.vaadin.flow.shared.communication.PushMode;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapHandler
extends SynchronizedRequestHandler {
    public static final String SERVICE_WORKER_HEADER = "Service-Worker";
    private static final String FETCH_DEST_HEADER = "Sec-Fetch-Dest";
    private static final CharSequence GWT_STAT_EVENTS_JS = "if (typeof window.__gwtStatsEvent != 'function') {window.Vaadin.Flow.gwtStatsEvents = [];window.__gwtStatsEvent = function(event) {window.Vaadin.Flow.gwtStatsEvents.push(event); return true;};};";
    protected static final String SCRIPT_TEMPLATE_FOR_STYLESHEET_LINK_TAG = "const link = document.createElement('link');link.rel = 'stylesheet';link.type = 'text/css';link.href = $0;document.head.appendChild(link);";
    static final String CONTENT_ATTRIBUTE = "content";
    private static final String DEFER_ATTRIBUTE = "defer";
    static final String VIEWPORT = "viewport";
    private static final String META_TAG = "meta";
    protected static final String SCRIPT_TAG = "script";
    private static final String CLIENT_ENGINE_NOCACHE_FILE = "VAADIN/static/client/client.nocache.js";
    private static final String BOOTSTRAP_JS = BootstrapHandler.readResource("BootstrapHandler.js");
    private static final String CSS_TYPE_ATTRIBUTE_VALUE = "text/css";
    private static final String CAPTION = "caption";
    private static final String MESSAGE = "message";
    private static final String URL = "url";
    private final PageBuilder pageBuilder;
    private static final Set<String> nonHtmlFetchDests;

    public BootstrapHandler() {
        this(new BootstrapPageBuilder());
    }

    protected BootstrapHandler(PageBuilder pageBuilder) {
        this.pageBuilder = pageBuilder;
    }

    protected PageBuilder getPageBuilder() {
        return this.pageBuilder;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)BootstrapHandler.class.getName());
    }

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        if (BootstrapHandler.isFrameworkInternalRequest(request)) {
            return false;
        }
        if (BootstrapHandler.isVaadinStaticFileRequest(request)) {
            return false;
        }
        if (!this.isRequestForHtml(request)) {
            return false;
        }
        return super.canHandleRequest(request);
    }

    public static boolean isFrameworkInternalRequest(VaadinRequest request) {
        if (request instanceof VaadinServletRequest) {
            return HandlerHelper.isInternalRequestInsideServlet(request.getPathInfo(), request.getParameter("v-r"));
        }
        return false;
    }

    public static boolean isVaadinStaticFileRequest(VaadinRequest request) {
        return request.getPathInfo() != null && request.getPathInfo().startsWith("/VAADIN/");
    }

    protected boolean isRequestForHtml(VaadinRequest request) {
        if (request.getHeader(SERVICE_WORKER_HEADER) != null) {
            return false;
        }
        String fetchDest = request.getHeader(FETCH_DEST_HEADER);
        if (fetchDest == null) {
            return true;
        }
        return !nonHtmlFetchDests.contains(fetchDest);
    }

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        if (this.writeErrorCodeIfRequestLocationIsInvalid(request, response)) {
            return true;
        }
        Class<? extends UI> uiClass = BootstrapHandler.getUIClass(request);
        BootstrapContext context = this.createAndInitUI(uiClass, request, response, session);
        HandlerHelper.setResponseNoCacheHeaders(response::setHeader, response::setDateHeader);
        Document document = this.pageBuilder.getBootstrapPage(context);
        this.writeBootstrapPage(response, document.outerHtml());
        return true;
    }

    protected boolean writeErrorCodeIfRequestLocationIsInvalid(VaadinRequest request, VaadinResponse response) throws IOException {
        try {
            LocationUtil.verifyRelativePath(LocationUtil.ensureRelativeNonNull(request.getPathInfo()));
        }
        catch (InvalidLocationException invalidLocationException) {
            response.sendError(400, "Invalid location: " + invalidLocationException.getMessage());
            return true;
        }
        return false;
    }

    private void writeBootstrapPage(VaadinResponse response, String html) throws IOException {
        response.setContentType("text/html; charset=utf-8");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(response.getOutputStream(), StandardCharsets.UTF_8));){
            writer.append(html);
        }
    }

    protected static Optional<String> resolvePageTitle(BootstrapContext context) {
        String title = context.getUI().getInternals().getTitle();
        if (title != null) {
            context.getUI().getInternals().cancelPendingTitleUpdate();
        }
        return Optional.ofNullable(title);
    }

    protected BootstrapContext createAndInitUI(Class<? extends UI> uiClass, VaadinRequest request, VaadinResponse response, VaadinSession session) {
        UI ui = ReflectTools.createInstance(uiClass);
        ui.getInternals().setContextRoot(request.getService().getContextRootRelativePath(request));
        PushConfiguration pushConfiguration = ui.getPushConfiguration();
        ui.getInternals().setSession(session);
        ui.setLocale(session.getLocale());
        BootstrapContext context = this.createBootstrapContext(request, response, ui, request.getService()::getContextRootRelativePath);
        Optional<Push> push = context.getPageConfigurationAnnotation(Push.class);
        DeploymentConfiguration deploymentConfiguration = context.getSession().getService().getDeploymentConfiguration();
        PushMode pushMode = push.map(Push::value).orElseGet(deploymentConfiguration::getPushMode);
        this.setupPushConnectionFactory(pushConfiguration, context);
        pushConfiguration.setPushMode(pushMode);
        pushConfiguration.setPushServletMapping(BootstrapHandlerHelper.determinePushServletMapping(session));
        push.map(Push::transport).ifPresent(pushConfiguration::setTransport);
        UI.setCurrent(ui);
        ui.doInit(request, session.getNextUIid(), context.getAppId());
        session.addUI(ui);
        session.getService().fireUIInitListeners(ui);
        this.initializeUIWithRouter(context, ui);
        return context;
    }

    protected void initializeUIWithRouter(BootstrapContext context, UI ui) {
        if (ui.getInternals().getRouter() != null) {
            ui.getInternals().getRouter().initializeUI(ui, context.getRoute());
        }
    }

    protected BootstrapContext createBootstrapContext(VaadinRequest request, VaadinResponse response, UI ui, Function<VaadinRequest, String> contextPathCallback) {
        return new BootstrapContext(request, response, ui.getInternals().getSession(), ui, contextPathCallback);
    }

    protected void setupPushConnectionFactory(PushConfiguration pushConfiguration, BootstrapContext context) {
        VaadinService service = context.getSession().getService();
        Iterator<PushConnectionFactory> iter = ServiceLoader.load(PushConnectionFactory.class, service.getClassLoader()).iterator();
        if (iter.hasNext()) {
            pushConfiguration.setPushConnectionFactory(iter.next());
            if (iter.hasNext()) {
                throw new BootstrapException("Multiple " + PushConnectionFactory.class.getName() + " implementations found");
            }
        }
    }

    protected static Class<? extends UI> getUIClass(VaadinRequest request) {
        String uiClassName = request.getService().getDeploymentConfiguration().getUIClassName();
        if (uiClassName == null) {
            throw new BootstrapException("Could not determine the uiClassName for the request path " + request.getPathInfo());
        }
        ClassLoader classLoader = request.getService().getClassLoader();
        try {
            return Class.forName(uiClassName, true, classLoader).asSubclass(UI.class);
        }
        catch (ClassNotFoundException e) {
            throw new BootstrapException("Vaadin Servlet mapped to the request path " + request.getPathInfo() + " cannot find the mapped UI class with name " + uiClassName, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected static String readResource(String fileName) {
        try (InputStream stream = BootstrapHandler.class.getResourceAsStream(fileName);){
            String string;
            try (BufferedReader bf = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                StringBuilder builder = new StringBuilder();
                bf.lines().forEach(builder::append);
                string = builder.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    protected static JsonObject getInitialUidl(UI ui) {
        JsonObject json = new UidlWriter().createUidl(ui, false);
        VaadinSession session = ui.getSession();
        if (session.getConfiguration().isXsrfProtectionEnabled()) {
            BootstrapHandler.writeSecurityKeyUIDL(json, ui);
        }
        BootstrapHandler.writePushIdUIDL(json, session);
        if (BootstrapHandler.getLogger().isDebugEnabled()) {
            BootstrapHandler.getLogger().debug("Initial UIDL: {}", (Object)json.asString());
        }
        return json;
    }

    private static void writePushIdUIDL(JsonObject response, VaadinSession session) {
        String pushId = session.getPushId();
        response.put("Vaadin-Push-ID", pushId);
    }

    private static void writeSecurityKeyUIDL(JsonObject response, UI ui) {
        String seckey = ui.getCsrfToken();
        response.put("Vaadin-Security-Key", seckey);
    }

    protected static String getPushScript(BootstrapContext context) {
        VaadinRequest request = context.getRequest();
        String versionQueryParam = "?v=" + Version.getBuildHash();
        String pushJSPath = BootstrapHandlerHelper.getServiceUrl(request) + "/";
        pushJSPath = request.getService().getDeploymentConfiguration().isProductionMode() ? pushJSPath + "VAADIN/static/push/vaadinPush-min.js" : pushJSPath + "VAADIN/static/push/vaadinPush.js";
        pushJSPath = pushJSPath + versionQueryParam;
        return pushJSPath;
    }

    protected static void setupErrorDialogs(Element style) {
        style.appendText(".v-reconnect-dialog,.v-system-error {position: absolute;color: black;background: white;top: 1em;right: 1em;border: 1px solid black;padding: 1em;z-index: 10000;max-width: calc(100vw - 4em);max-height: calc(100vh - 4em);overflow: auto;} .v-system-error {color: indianred;pointer-events: auto;} .v-system-error h3, .v-system-error b {color: red;}");
    }

    protected static void setupHiddenElement(Element styles) {
        styles.appendText("[hidden] { display: none !important; }");
    }

    protected static void setupPwa(Document document, VaadinService service) {
        BootstrapHandler.setupPwa(document, service.getPwaRegistry());
    }

    protected static JsonObject getStatsJson(DeploymentConfiguration config) throws IOException {
        String statsJson = DevBundleUtils.findBundleStatsJson(config.getProjectFolder());
        Objects.requireNonNull(statsJson, "Frontend development bundle is expected to be in the project or on the classpath, but not found.");
        return Json.parse((String)statsJson);
    }

    protected static Collection<Element> getStylesheetTags(VaadinContext context, String fileName) throws IOException {
        ApplicationConfiguration config = ApplicationConfiguration.get(context);
        return ThemeUtils.getActiveThemes(context).stream().map(theme -> BootstrapHandler.getStyleTag(theme, fileName, config)).toList();
    }

    protected static Collection<String> getStylesheetLinks(VaadinContext context, String fileName) {
        return ThemeUtils.getActiveThemes(context).stream().map(theme -> ThemeUtils.getThemeFilePath(theme, fileName)).toList();
    }

    private static Element getStyleTag(String themeName, String fileName, AbstractConfiguration config) {
        Element element;
        try {
            String themeFilePath = ThemeUtils.getThemeFilePath(themeName, fileName);
            if (config.isProductionMode()) {
                element = new Element("link");
                element.attr("rel", "stylesheet");
                element.attr("type", CSS_TYPE_ATTRIBUTE_VALUE);
                element.attr("href", themeFilePath);
            } else {
                element = new Element("style");
                element.attr("data-file-path", themeFilePath);
                File frontendDirectory = FrontendUtils.getProjectFrontendDir(config);
                File stylesCss = new File(ThemeUtils.getThemeFolder(frontendDirectory, themeName), fileName);
                element.appendChild((Node)new DataNode(CssBundler.inlineImports(stylesCss.getParentFile(), stylesCss)));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read theme file from " + fileName, e);
        }
        return element;
    }

    private static void setupPwa(Document document, PwaRegistry registry) {
        if (registry == null) {
            return;
        }
        PwaConfiguration config = registry.getPwaConfiguration();
        if (config.isEnabled()) {
            Element head = document.head();
            head.appendElement(META_TAG).attr("name", "apple-mobile-web-app-capable").attr(CONTENT_ATTRIBUTE, "yes");
            head.appendElement(META_TAG).attr("name", "mobile-web-app-capable").attr(CONTENT_ATTRIBUTE, "yes");
            head.appendElement(META_TAG).attr("name", "apple-touch-fullscreen").attr(CONTENT_ATTRIBUTE, "yes");
            head.appendElement(META_TAG).attr("name", "apple-mobile-web-app-title").attr(CONTENT_ATTRIBUTE, config.getShortName());
            head.appendElement(META_TAG).attr("name", "theme-color").attr(CONTENT_ATTRIBUTE, config.getThemeColor());
            head.appendElement(META_TAG).attr("name", "apple-mobile-web-app-status-bar-style").attr(CONTENT_ATTRIBUTE, config.getThemeColor());
            head.appendElement("link").attr("rel", "manifest").attr("href", config.getManifestPath());
            for (PwaIcon icon : registry.getHeaderIcons()) {
                head.appendChild((Node)icon.asElement());
            }
            if (config.isOfflineEnabled()) {
                head.appendElement(SCRIPT_TAG).text(String.format("if ('serviceWorker' in navigator) {\n  window.addEventListener('load', function() {\n    navigator.serviceWorker.register('%s')\n  });\n}", config.getServiceWorkerPath()));
            } else {
                head.appendElement(SCRIPT_TAG).text(String.format("if ('serviceWorker' in navigator) {\n  navigator.serviceWorker.getRegistration('%s').then(function(registration) {\n    if (registration) {\n      registration.unregister();\n    }\n  });\n}", config.getServiceWorkerPath()));
            }
        }
    }

    static {
        HashSet<String> dests = new HashSet<String>();
        dests.add("audio");
        dests.add("audioworklet");
        dests.add("font");
        dests.add("image");
        dests.add("manifest");
        dests.add("paintworklet");
        dests.add(SCRIPT_TAG);
        dests.add("serviceworker");
        dests.add("sharedworker");
        dests.add("style");
        dests.add("track");
        dests.add("video");
        dests.add("worker");
        dests.add("xslt");
        nonHtmlFetchDests = Collections.unmodifiableSet(dests);
    }

    protected static class BootstrapPageBuilder
    implements PageBuilder {
        protected BootstrapPageBuilder() {
        }

        @Override
        public Document getBootstrapPage(BootstrapContext context) {
            DeploymentConfiguration config = context.getSession().getConfiguration();
            Document document = new Document("");
            DocumentType doctype = new DocumentType("html", "", "");
            document.appendChild((Node)doctype);
            Element html = document.appendElement("html");
            html.attr("lang", context.getUI().getLocale().getLanguage());
            Element head = html.appendElement("head");
            html.appendElement("body");
            List<Element> dependenciesToInlineInBody = this.setupDocumentHead(head, context);
            dependenciesToInlineInBody.forEach(dependency -> document.body().appendChild((Node)dependency));
            this.setupDocumentBody(document);
            document.outputSettings().prettyPrint(false);
            BootstrapUtils.getInlineTargets(context).ifPresent(targets -> this.handleInlineTargets(context, head, document.body(), (InlineTargets)targets));
            if (!config.isProductionMode()) {
                UsageStatisticsExporter.exportUsageStatisticsToDocument(document);
                IndexHtmlRequestHandler.addLicenseChecker(document);
            }
            this.setupPwa(document, context);
            return document;
        }

        private Element createDependencyElement(BootstrapContext context, JsonObject dependencyJson) {
            String type = dependencyJson.getString("type");
            if (Dependency.Type.contains(type)) {
                Dependency.Type dependencyType = Dependency.Type.valueOf(type);
                return this.createDependencyElement(context.getUriResolver(), LoadMode.INLINE, dependencyJson, dependencyType);
            }
            return Jsoup.parse((String)dependencyJson.getString("contents"), (String)"", (Parser)Parser.xmlParser());
        }

        private void handleInlineTargets(BootstrapContext context, Element head, Element body, InlineTargets targets) {
            targets.getInlineHead(Inline.Position.PREPEND).stream().map(dependency -> this.createDependencyElement(context, (JsonObject)dependency)).forEach(element -> this.insertElements((Element)element, arg_0 -> ((Element)head).prependChild(arg_0)));
            targets.getInlineHead(Inline.Position.APPEND).stream().map(dependency -> this.createDependencyElement(context, (JsonObject)dependency)).forEach(element -> this.insertElements((Element)element, arg_0 -> ((Element)head).appendChild(arg_0)));
            targets.getInlineBody(Inline.Position.PREPEND).stream().map(dependency -> this.createDependencyElement(context, (JsonObject)dependency)).forEach(element -> this.insertElements((Element)element, arg_0 -> ((Element)body).prependChild(arg_0)));
            targets.getInlineBody(Inline.Position.APPEND).stream().map(dependency -> this.createDependencyElement(context, (JsonObject)dependency)).forEach(element -> this.insertElements((Element)element, arg_0 -> ((Element)body).appendChild(arg_0)));
        }

        private void insertElements(Element element, Consumer<Element> action) {
            if (element instanceof Document) {
                element.getAllElements().stream().filter(item -> !(item instanceof Document) && element.equals((Object)item.parent())).forEach(action::accept);
            } else if (element != null) {
                action.accept(element);
            }
        }

        private List<Element> setupDocumentHead(Element head, BootstrapContext context) {
            this.setupMetaAndTitle(head, context);
            this.setupCss(head, context);
            JsonObject initialUIDL = this.getInitialUidl(context.getUI());
            Map<LoadMode, JsonArray> dependenciesToProcessOnServer = this.popDependenciesToProcessOnServer(initialUIDL);
            this.setupFrameworkLibraries(head, initialUIDL, context);
            return this.applyUserDependencies(head, context, dependenciesToProcessOnServer);
        }

        private JsonObject getInitialUidl(UI ui) {
            JsonObject json = new UidlWriter().createUidl(ui, false);
            VaadinSession session = ui.getSession();
            if (session.getConfiguration().isXsrfProtectionEnabled()) {
                this.writeSecurityKeyUIDL(json, ui);
            }
            this.writePushIdUIDL(json, session);
            if (BootstrapHandler.getLogger().isDebugEnabled()) {
                BootstrapHandler.getLogger().debug("Initial UIDL: {}", (Object)json.asString());
            }
            return json;
        }

        private void writePushIdUIDL(JsonObject response, VaadinSession session) {
            String pushId = session.getPushId();
            response.put("Vaadin-Push-ID", pushId);
        }

        private void writeSecurityKeyUIDL(JsonObject response, UI ui) {
            String seckey = ui.getCsrfToken();
            response.put("Vaadin-Security-Key", seckey);
        }

        private List<Element> applyUserDependencies(Element head, BootstrapContext context, Map<LoadMode, JsonArray> dependenciesToProcessOnServer) {
            ArrayList<Element> dependenciesToInlineInBody = new ArrayList<Element>();
            for (Map.Entry<LoadMode, JsonArray> entry : dependenciesToProcessOnServer.entrySet()) {
                dependenciesToInlineInBody.addAll(this.inlineDependenciesInHead(head, context.getUriResolver(), entry.getKey(), entry.getValue()));
            }
            return dependenciesToInlineInBody;
        }

        private List<Element> inlineDependenciesInHead(Element head, BootstrapUriResolver uriResolver, LoadMode loadMode, JsonArray dependencies) {
            ArrayList<Element> dependenciesToInlineInBody = new ArrayList<Element>();
            for (int i = 0; i < dependencies.length(); ++i) {
                JsonObject dependencyJson = dependencies.getObject(i);
                Dependency.Type dependencyType = Dependency.Type.valueOf(dependencyJson.getString("type"));
                Element dependencyElement = this.createDependencyElement(uriResolver, loadMode, dependencyJson, dependencyType);
                head.appendChild((Node)dependencyElement);
            }
            return dependenciesToInlineInBody;
        }

        private Map<LoadMode, JsonArray> popDependenciesToProcessOnServer(JsonObject initialUIDL) {
            EnumMap<LoadMode, JsonArray> result = new EnumMap<LoadMode, JsonArray>(LoadMode.class);
            Stream.of(LoadMode.EAGER, LoadMode.INLINE).forEach(mode -> {
                if (initialUIDL.hasKey(mode.name())) {
                    result.put((LoadMode)((Object)mode), initialUIDL.getArray(mode.name()));
                    initialUIDL.remove(mode.name());
                }
            });
            return result;
        }

        private void setupFrameworkLibraries(Element head, JsonObject initialUIDL, BootstrapContext context) {
            VaadinService service = context.getSession().getService();
            DeploymentConfiguration conf = service.getDeploymentConfiguration();
            conf.getPolyfills().forEach(polyfill -> head.appendChild((Node)BootstrapPageBuilder.createJavaScriptElement("./VAADIN/" + polyfill, false)));
            try {
                this.appendNpmBundle(head, service, context);
            }
            catch (IOException e) {
                throw new BootstrapException("Unable to append bundle", e);
            }
            if (context.getPushMode().isEnabled()) {
                head.appendChild((Node)BootstrapPageBuilder.createJavaScriptElement(BootstrapHandler.getPushScript(context)));
            }
            head.appendChild((Node)this.getBootstrapScript((JsonValue)initialUIDL, context));
            head.appendChild((Node)BootstrapPageBuilder.createJavaScriptElement(this.getClientEngineUrl(context)));
        }

        private void appendNpmBundle(Element head, VaadinService service, BootstrapContext context) throws IOException {
            this.appendViteNpmBundle(head, service, context);
        }

        private void appendViteNpmBundle(Element head, VaadinService service, BootstrapContext context) throws IOException {
            if (!service.getDeploymentConfiguration().isProductionMode()) {
                Element script = BootstrapPageBuilder.createJavaScriptModuleElement("VAADIN/@vite/client", false);
                head.appendChild((Node)script);
                return;
            }
            String index = FrontendUtils.getIndexHtmlContent(service);
            Matcher scriptMatcher = Pattern.compile("src=\\\"VAADIN\\/build\\/(.*\\.js)\\\"").matcher(index);
            while (scriptMatcher.find()) {
                Element script = BootstrapPageBuilder.createJavaScriptModuleElement("VAADIN/build/" + scriptMatcher.group(1), false);
                head.appendChild((Node)script.attr("async", true).attr("crossorigin", true));
            }
            Matcher cssMatcher = Pattern.compile("href=\\\"VAADIN\\/build\\/(.*\\.css)\\\"").matcher(index);
            while (cssMatcher.find()) {
                Element link = this.createStylesheetElement("VAADIN/build/" + cssMatcher.group(1));
                head.appendChild((Node)link);
            }
        }

        protected List<String> getChunkKeys(JsonObject chunks) {
            return Arrays.stream(chunks.keys()).filter(s -> !"export".equals(s)).collect(Collectors.toList());
        }

        private String getClientEngineUrl(BootstrapContext context) {
            boolean resolveNow;
            boolean productionMode = context.getSession().getConfiguration().isProductionMode();
            ResourceProvider resourceProvider = this.getResourceProvider(context);
            String clientEngine = this.getClientEngine(resourceProvider);
            boolean bl = resolveNow = !productionMode || clientEngine == null;
            if (resolveNow && resourceProvider.getClientResource("META-INF/resources/VAADIN/static/client/client.nocache.js") != null) {
                return context.getUriResolver().resolveVaadinUri("context://VAADIN/static/client/client.nocache.js");
            }
            if (clientEngine == null) {
                throw new BootstrapException("Client engine file name has not been resolved during initialization");
            }
            return context.getUriResolver().resolveVaadinUri("context://" + clientEngine);
        }

        private ResourceProvider getResourceProvider(BootstrapContext context) {
            ResourceProvider resourceProvider = context.getSession().getService().getContext().getAttribute(Lookup.class).lookup(ResourceProvider.class);
            return resourceProvider;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getClientEngine(ResourceProvider resourceProvider) {
            try (InputStream prop = resourceProvider.getClientResourceAsStream("META-INF/resources/VAADIN/static/client/compile.properties");){
                if (prop != null) {
                    Properties properties = new Properties();
                    properties.load(prop);
                    String string = "VAADIN/static/client/" + properties.getProperty("jsFile");
                    return string;
                }
                BootstrapHandler.getLogger().warn("No compile.properties available on initialization, could not read client engine file name.");
                return null;
            }
            catch (IOException e) {
                throw new ExceptionInInitializerError(e);
            }
        }

        protected void setupCss(Element head, BootstrapContext context) {
            Element styles = head.appendElement("style").attr("type", BootstrapHandler.CSS_TYPE_ATTRIBUTE_VALUE);
            String bodySizeContent = BootstrapUtils.getBodySizeContent(context);
            styles.appendText(bodySizeContent);
            BootstrapHandler.setupErrorDialogs(styles);
            BootstrapHandler.setupHiddenElement(styles);
        }

        private void setupMetaAndTitle(Element head, BootstrapContext context) {
            head.appendElement(BootstrapHandler.META_TAG).attr("http-equiv", "Content-Type").attr(BootstrapHandler.CONTENT_ATTRIBUTE, "text/html; charset=utf-8");
            head.appendElement(BootstrapHandler.META_TAG).attr("http-equiv", "X-UA-Compatible").attr(BootstrapHandler.CONTENT_ATTRIBUTE, "IE=edge");
            head.appendElement("base").attr("href", BootstrapHandlerHelper.getServiceUrl(context.getRequest()));
            head.appendElement(BootstrapHandler.META_TAG).attr("name", BootstrapHandler.VIEWPORT).attr(BootstrapHandler.CONTENT_ATTRIBUTE, BootstrapUtils.getViewportContent(context).orElse("width=device-width, initial-scale=1.0"));
            BootstrapUtils.getMetaTargets(context).forEach((name, content) -> head.appendElement(BootstrapHandler.META_TAG).attr("name", name).attr(BootstrapHandler.CONTENT_ATTRIBUTE, content));
            BootstrapHandler.resolvePageTitle(context).ifPresent(title -> {
                if (!title.isEmpty()) {
                    head.appendElement("title").appendText(title);
                }
            });
        }

        private void setupPwa(Document document, BootstrapContext context) {
            BootstrapHandler.setupPwa(document, context.getPwaRegistry().orElse(null));
        }

        protected Element createInlineJavaScriptElement(String javaScriptContents) {
            Element wrapper = BootstrapPageBuilder.createJavaScriptElement(null, false);
            wrapper.appendChild((Node)new DataNode(javaScriptContents));
            return wrapper;
        }

        protected static Element createJavaScriptElement(String sourceUrl, boolean defer) {
            return BootstrapPageBuilder.createJavaScriptElement(sourceUrl, defer, "text/javascript");
        }

        protected static Element createJavaScriptModuleElement(String sourceUrl, boolean defer) {
            return BootstrapPageBuilder.createJavaScriptElement(sourceUrl, defer, "module");
        }

        protected static Element createJavaScriptElement(String sourceUrl, boolean defer, String type) {
            Element jsElement = new Element(Tag.valueOf((String)BootstrapHandler.SCRIPT_TAG), "").attr("type", type).attr(BootstrapHandler.DEFER_ATTRIBUTE, defer);
            if (sourceUrl != null) {
                jsElement = jsElement.attr("src", sourceUrl);
            }
            return jsElement;
        }

        protected static Element createJavaScriptElement(String sourceUrl) {
            return BootstrapPageBuilder.createJavaScriptElement(sourceUrl, true);
        }

        private Element createDependencyElement(BootstrapUriResolver resolver, LoadMode loadMode, JsonObject dependency, Dependency.Type type) {
            boolean inlineElement = loadMode == LoadMode.INLINE;
            String url = dependency.hasKey(BootstrapHandler.URL) ? resolver.resolveVaadinUri(dependency.getString(BootstrapHandler.URL)) : null;
            Element dependencyElement = switch (type) {
                case Dependency.Type.STYLESHEET -> this.createStylesheetElement(url);
                case Dependency.Type.JAVASCRIPT -> BootstrapPageBuilder.createJavaScriptElement(url, !inlineElement);
                case Dependency.Type.JS_MODULE -> BootstrapPageBuilder.createJavaScriptModuleElement(url, false);
                default -> throw new IllegalStateException("Unsupported dependency type: " + type);
            };
            if (inlineElement) {
                dependencyElement.appendChild((Node)new DataNode(dependency.getString("contents")));
            }
            return dependencyElement;
        }

        private Element createStylesheetElement(String url) {
            Element cssElement = url != null ? new Element(Tag.valueOf((String)"link"), "").attr("rel", "stylesheet").attr("type", BootstrapHandler.CSS_TYPE_ATTRIBUTE_VALUE).attr("href", url) : new Element(Tag.valueOf((String)"style"), "").attr("type", BootstrapHandler.CSS_TYPE_ATTRIBUTE_VALUE);
            return cssElement;
        }

        private void setupDocumentBody(Document document) {
            document.body().appendElement("noscript").append("You have to enable javascript in your browser to use this web site.");
        }

        protected Element getBootstrapScript(JsonValue initialUIDL, BootstrapContext context) {
            return this.createInlineJavaScriptElement("//<![CDATA[\n" + this.getBootstrapJS(initialUIDL, context) + "//]]>");
        }

        private String getBootstrapJS() {
            if (BOOTSTRAP_JS.isEmpty()) {
                throw new BootstrapException("BootstrapHandler.js has not been loaded during initialization");
            }
            return BOOTSTRAP_JS;
        }

        private String getBootstrapJS(JsonValue initialUIDL, BootstrapContext context) {
            boolean productionMode = context.getSession().getConfiguration().isProductionMode();
            String result = this.getBootstrapJS();
            JsonObject appConfig = context.getApplicationParameters();
            int indent = 0;
            if (!productionMode) {
                indent = 4;
            }
            String appConfigString = JsonUtil.stringify((JsonValue)appConfig, (int)indent);
            String initialUIDLString = JsonUtil.stringify((JsonValue)initialUIDL, (int)indent);
            initialUIDLString = initialUIDLString.replace("<", "\\x3C");
            result = !productionMode ? result.replace("{{GWT_STAT_EVENTS}}", GWT_STAT_EVENTS_JS) : result.replace("{{GWT_STAT_EVENTS}}", "");
            result = result.replace("{{APP_ID}}", context.getAppId());
            result = result.replace("{{CONFIG_JSON}}", appConfigString);
            result = result.replace("{{INITIAL_UIDL}}", initialUIDLString);
            result = result.replace("{{PRODUCTION_MODE}}", String.valueOf(productionMode));
            return result;
        }
    }

    public static interface PageBuilder
    extends Serializable {
        public Document getBootstrapPage(BootstrapContext var1);
    }

    protected static class BootstrapContext {
        private final VaadinRequest request;
        private final VaadinResponse response;
        private final VaadinSession session;
        private final UI ui;
        private final Class<?> pageConfigurationHolder;
        private final ApplicationParameterBuilder parameterBuilder;
        private final Location route;
        private String appId;
        private PushMode pushMode;
        private JsonObject applicationParameters;
        private BootstrapUriResolver uriResolver;
        private boolean initTheme = true;

        protected BootstrapContext(VaadinRequest request, VaadinResponse response, VaadinSession session, UI ui, Function<VaadinRequest, String> contextCallback) {
            this(request, response, session, ui, contextCallback, req -> new Location(req.getPathInfo(), QueryParameters.full(req.getParameterMap())));
        }

        protected BootstrapContext(VaadinRequest request, VaadinResponse response, VaadinSession session, UI ui, Function<VaadinRequest, String> contextCallback, Function<VaadinRequest, Location> routeCallback) {
            this.request = request;
            this.response = response;
            this.session = session;
            this.ui = ui;
            this.route = routeCallback.apply(request);
            this.parameterBuilder = new ApplicationParameterBuilder(contextCallback);
            this.pageConfigurationHolder = BootstrapUtils.resolvePageConfigurationHolder(ui, this.route).orElse(null);
        }

        public VaadinResponse getResponse() {
            return this.response;
        }

        public VaadinRequest getRequest() {
            return this.request;
        }

        public VaadinService getService() {
            return this.request.getService();
        }

        public VaadinSession getSession() {
            return this.session;
        }

        public boolean isInitTheme() {
            return this.initTheme;
        }

        public void setInitTheme(boolean initTheme) {
            this.initTheme = initTheme;
        }

        public UI getUI() {
            return this.ui;
        }

        public PushMode getPushMode() {
            if (this.pushMode == null) {
                this.pushMode = this.getUI().getPushConfiguration().getPushMode();
                if (this.pushMode == null) {
                    this.pushMode = this.getService().getDeploymentConfiguration().getPushMode();
                }
                if (this.pushMode.isEnabled() && !this.getService().ensurePushAvailable()) {
                    this.pushMode = PushMode.DISABLED;
                }
            }
            return this.pushMode;
        }

        public String getAppId() {
            if (this.appId == null) {
                this.appId = this.getService().getMainDivId(this.getSession(), this.getRequest());
            }
            return this.appId;
        }

        public JsonObject getApplicationParameters() {
            if (this.applicationParameters == null) {
                this.applicationParameters = this.parameterBuilder.getApplicationParameters(this);
            }
            return this.applicationParameters;
        }

        public BootstrapUriResolver getUriResolver() {
            if (this.uriResolver == null) {
                this.uriResolver = new BootstrapUriResolver(this.getUI());
            }
            return this.uriResolver;
        }

        public boolean isProductionMode() {
            return this.getService().getDeploymentConfiguration().isProductionMode();
        }

        public <T extends Annotation> Optional<T> getPageConfigurationAnnotation(Class<T> annotationType) {
            if (this.pageConfigurationHolder == null) {
                return Optional.empty();
            }
            return AnnotationReader.getAnnotationFor(this.pageConfigurationHolder, annotationType);
        }

        public <T extends Annotation> List<T> getPageConfigurationAnnotations(Class<T> annotationType) {
            if (this.pageConfigurationHolder == null) {
                return Collections.emptyList();
            }
            return AnnotationReader.getAnnotationsFor(this.pageConfigurationHolder, annotationType);
        }

        protected Optional<PwaRegistry> getPwaRegistry() {
            VaadinService vaadinService = this.getSession().getService();
            if (vaadinService == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(vaadinService.getPwaRegistry());
        }

        public Location getRoute() {
            return this.route;
        }
    }

    private static final class ApplicationParameterBuilder {
        private final Function<VaadinRequest, String> contextCallback;

        private ApplicationParameterBuilder(Function<VaadinRequest, String> contextCallback) {
            this.contextCallback = contextCallback;
        }

        public JsonObject getApplicationParameters(BootstrapContext context) {
            VaadinRequest request = context.getRequest();
            VaadinSession session = context.getSession();
            DeploymentConfiguration deploymentConfiguration = session.getConfiguration();
            boolean productionMode = deploymentConfiguration.isProductionMode();
            JsonObject appConfig = Json.createObject();
            if (!productionMode) {
                JsonObject versionInfo = Json.createObject();
                versionInfo.put("vaadinVersion", Version.getFullVersion());
                String atmosphereVersion = AtmospherePushConnection.getAtmosphereVersion();
                if (atmosphereVersion != null) {
                    versionInfo.put("atmosphereVersion", atmosphereVersion);
                }
                appConfig.put("versionInfo", (JsonValue)versionInfo);
                appConfig.put("devToolsEnabled", deploymentConfiguration.isDevToolsEnabled());
            }
            Locale locale = HandlerHelper.findLocale(session, request);
            SystemMessages systemMessages = session.getService().getSystemMessages(locale, request);
            if (systemMessages != null) {
                JsonObject sessExpMsg = Json.createObject();
                this.putValueOrNull(sessExpMsg, BootstrapHandler.CAPTION, systemMessages.getSessionExpiredCaption());
                this.putValueOrNull(sessExpMsg, BootstrapHandler.MESSAGE, systemMessages.getSessionExpiredMessage());
                this.putValueOrNull(sessExpMsg, BootstrapHandler.URL, systemMessages.getSessionExpiredURL());
                appConfig.put("sessExpMsg", (JsonValue)sessExpMsg);
            }
            String contextRoot = this.contextCallback.apply(request);
            appConfig.put("contextRootUrl", contextRoot);
            if (!productionMode) {
                appConfig.put("debug", true);
            }
            if (deploymentConfiguration.isRequestTiming()) {
                appConfig.put("requestTiming", true);
            }
            appConfig.put("heartbeatInterval", (double)deploymentConfiguration.getHeartbeatInterval());
            appConfig.put("maxMessageSuspendTimeout", (double)deploymentConfiguration.getMaxMessageSuspendTimeout());
            boolean sendUrlsAsParameters = deploymentConfiguration.isSendUrlsAsParameters();
            if (!sendUrlsAsParameters) {
                appConfig.put("sendUrlsAsParameters", false);
            }
            appConfig.put("v-uiId", (double)context.getUI().getUIId());
            return appConfig;
        }

        private void putValueOrNull(JsonObject object, String key, String value) {
            assert (object != null);
            assert (key != null);
            if (value == null) {
                object.put(key, (JsonValue)Json.createNull());
            } else {
                object.put(key, value);
            }
        }
    }

    public static class BootstrapUriResolver
    extends VaadinUriResolver {
        private String servletPathToContextRoot;

        protected BootstrapUriResolver(UI ui) {
            this(ui.getInternals().getContextRootRelativePath(), ui.getSession());
        }

        public BootstrapUriResolver(String contextRootRelatiePath, VaadinSession session) {
            this.servletPathToContextRoot = contextRootRelatiePath;
            assert (this.servletPathToContextRoot.endsWith("/"));
        }

        public String resolveVaadinUri(String uri) {
            return super.resolveVaadinUri(uri, this.servletPathToContextRoot);
        }
    }
}

