/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.SystemMessages;
import com.vaadin.flow.server.VaadinSessionState;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;

public class MetadataWriter
implements Serializable {
    private int timeoutInterval = -1;

    public JsonObject createMetadata(UI ui, boolean repaintAll, boolean async, SystemMessages messages) {
        VaadinSessionState state;
        JsonObject meta = Json.createObject();
        if (repaintAll) {
            meta.put("repaintAll", true);
        }
        if (async) {
            meta.put("async", true);
        }
        if ((state = ui.getSession().getState()) != null && state.compareTo(VaadinSessionState.CLOSING) >= 0) {
            meta.put("sessionExpired", true);
        }
        if (messages != null && messages.getSessionExpiredMessage() == null && messages.getSessionExpiredCaption() == null && messages.isSessionExpiredNotificationEnabled() && ui.getSession().getSession() != null) {
            int newTimeoutInterval = ui.getSession().getSession().getMaxInactiveInterval();
            if (repaintAll || this.timeoutInterval != newTimeoutInterval) {
                String url = messages.getSessionExpiredURL();
                if (url == null) {
                    url = "";
                }
                int redirectInterval = newTimeoutInterval + 15;
                JsonObject redirect = Json.createObject();
                redirect.put("interval", (double)redirectInterval);
                redirect.put("url", url);
                meta.put("timedRedirect", (JsonValue)redirect);
            }
            this.timeoutInterval = newTimeoutInterval;
        }
        return meta;
    }
}

