/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vaadin.hilla.EndpointController;
import com.vaadin.hilla.ExplicitNullableTypeChecker;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExplicitNullableTypeCheckerHelper {
    private Map<Type, Set<Object>> visitedBeans;
    private boolean requiredByContext;

    private static Logger getLogger() {
        return LoggerFactory.getLogger(EndpointController.class);
    }

    public ExplicitNullableTypeCheckerHelper(boolean requiredByContext) {
        this.requiredByContext = requiredByContext;
    }

    boolean hasVisited(Object value, Type type) {
        if (this.visitedBeans == null) {
            return false;
        }
        Set<Object> values = this.visitedBeans.get(type);
        if (values == null) {
            return false;
        }
        return values.contains(value);
    }

    void markAsVisited(Object value, Type type) {
        if (this.visitedBeans == null) {
            this.visitedBeans = new HashMap<Type, Set<Object>>();
        }
        this.visitedBeans.putIfAbsent(type, new HashSet());
        this.visitedBeans.get(type).add(value);
    }

    String checkValueForType(Object value, Type expectedType) {
        if (expectedType instanceof TypeVariable) {
            return null;
        }
        Class clazz = expectedType instanceof ParameterizedType ? (Class)((ParameterizedType)expectedType).getRawType() : (Class)expectedType;
        if (value != null) {
            if (Iterable.class.isAssignableFrom(clazz)) {
                return this.checkIterable((Iterable)value, expectedType);
            }
            if (clazz.isArray() && value instanceof Object[]) {
                return this.checkIterable(Arrays.asList((Object[])value), expectedType);
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return this.checkMapValues((Map)value, expectedType);
            }
            if (expectedType instanceof Class && !clazz.getName().startsWith("java.")) {
                return this.checkBeanFields(value, expectedType);
            }
            return null;
        }
        if (expectedType.equals(Void.TYPE)) {
            return null;
        }
        if (Void.class.isAssignableFrom(clazz)) {
            return null;
        }
        if (Optional.class.isAssignableFrom(clazz)) {
            return String.format("Got null value for type '%s', consider Optional.empty", expectedType.getTypeName());
        }
        return String.format("Got null value for type '%s', which is neither Optional nor void", expectedType.getTypeName());
    }

    private String checkIterable(Iterable<?> value, Type expectedType) {
        Class<?> itemType = Object.class;
        String iterableDescription = "iterable";
        if (expectedType instanceof ParameterizedType) {
            itemType = ((ParameterizedType)expectedType).getActualTypeArguments()[0];
            iterableDescription = "collection";
        } else if (expectedType instanceof Class) {
            itemType = ((Class)expectedType).getComponentType();
            iterableDescription = "array";
        }
        for (Object item : value) {
            String error = this.checkValueForType(item, itemType);
            if (error == null) continue;
            return String.format("Unexpected null item in %s type '%s'. %s", iterableDescription, expectedType, error);
        }
        return null;
    }

    private String checkMapValues(Map<?, ?> value, Type expectedType) {
        Object valueType = Object.class;
        if (expectedType instanceof ParameterizedType) {
            valueType = ((ParameterizedType)expectedType).getActualTypeArguments()[1];
        }
        for (Map.Entry<?, ?> e : value.entrySet()) {
            String error = this.checkValueForType(e.getValue(), (Type)valueType);
            if (error == null) continue;
            return String.format("Unexpected null value for key '%s' of map type '%s'. %s", e.getKey(), expectedType, error);
        }
        return null;
    }

    private String checkBeanFields(Object value, Type expectedType) {
        if (this.hasVisited(value, expectedType)) {
            return null;
        }
        this.markAsVisited(value, expectedType);
        Class clazz = (Class)expectedType;
        try {
            for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                if (!this.isPropertySubjectForChecking(propertyDescriptor)) continue;
                Method readMethod = propertyDescriptor.getReadMethod();
                Type propertyType = readMethod.getGenericReturnType();
                Object propertyValue = readMethod.invoke(value, new Object[0]);
                String error = this.checkValueForType(propertyValue, propertyType);
                if (error == null) continue;
                return String.format("Unexpected null value in Java Bean type '%s' property '%s'. %s", expectedType.getTypeName(), propertyDescriptor.getName(), error);
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            ExplicitNullableTypeCheckerHelper.getLogger().error("Cannot check for null property values in Java Bean", (Throwable)e);
            return e.toString();
        }
        return null;
    }

    private boolean isPropertySubjectForChecking(PropertyDescriptor propertyDescriptor) {
        try {
            String name = propertyDescriptor.getName();
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod == null) {
                return false;
            }
            Class<?> declaringClass = readMethod.getDeclaringClass();
            Set declaredFieldNames = Arrays.stream(declaringClass.getDeclaredFields()).map(Field::getName).collect(Collectors.toSet());
            if (!declaredFieldNames.contains(name)) {
                return false;
            }
            Field field = readMethod.getDeclaringClass().getDeclaredField(name);
            return !Modifier.isStatic(field.getModifiers()) && !Modifier.isTransient(field.getModifiers()) && ExplicitNullableTypeChecker.isRequired(field, this.requiredByContext) && !field.isAnnotationPresent(JsonIgnore.class);
        }
        catch (NoSuchFieldException e) {
            ExplicitNullableTypeCheckerHelper.getLogger().error("Unexpected missing declared field in Java Bean", (Throwable)e);
            return false;
        }
    }
}

