/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.crud;

import com.vaadin.hilla.crud.PropertyStringFilterSpecification;
import com.vaadin.hilla.crud.filter.AndFilter;
import com.vaadin.hilla.crud.filter.Filter;
import com.vaadin.hilla.crud.filter.OrFilter;
import com.vaadin.hilla.crud.filter.PropertyStringFilter;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Root;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class JpaFilterConverter {
    @Autowired
    private EntityManager em;

    public <T> Specification<T> toSpec(Filter rawFilter, Class<T> entity) {
        if (rawFilter == null) {
            return Specification.anyOf((Specification[])new Specification[0]);
        }
        if (rawFilter instanceof AndFilter) {
            AndFilter filter = (AndFilter)rawFilter;
            return Specification.allOf(filter.getChildren().stream().map(f -> this.toSpec((Filter)f, entity)).toList());
        }
        if (rawFilter instanceof OrFilter) {
            OrFilter filter = (OrFilter)rawFilter;
            return Specification.anyOf(filter.getChildren().stream().map(f -> this.toSpec((Filter)f, entity)).toList());
        }
        if (rawFilter instanceof PropertyStringFilter) {
            PropertyStringFilter filter = (PropertyStringFilter)rawFilter;
            Class<?> javaType = this.extractPropertyJavaType(entity, filter.getPropertyId());
            return new PropertyStringFilterSpecification(filter, javaType);
        }
        if (rawFilter != null) {
            throw new IllegalArgumentException("Unknown filter type " + rawFilter.getClass().getName());
        }
        return Specification.anyOf((Specification[])new Specification[0]);
    }

    private Class<?> extractPropertyJavaType(Class<?> entity, String propertyId) {
        if (propertyId.contains(".")) {
            String[] parts = propertyId.split("\\.");
            Root root = this.em.getCriteriaBuilder().createQuery(entity).from(entity);
            Path path = root.get(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                path = path.get(parts[i]);
            }
            return path.getJavaType();
        }
        return this.em.getMetamodel().entity(entity).getAttribute(propertyId).getJavaType();
    }
}

