/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.internal.hotswap;

import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.shared.Registration;
import com.vaadin.hilla.engine.EngineConfiguration;
import com.vaadin.hilla.engine.ParserProcessor;
import com.vaadin.hilla.internal.hotswap.EndpointHotSwapService;
import com.vaadin.hilla.internal.hotswap.HotSwapListener;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PollChangedEndpointsHotSwapService
implements EndpointHotSwapService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollChangedEndpointsHotSwapService.class);
    private final Collection<HotSwapListener> hotSwapListeners = new ArrayList<HotSwapListener>();
    private final int endpointHotReloadPollInterval;
    private Path buildDir;
    private BrowserLiveReload browserLiveReload;

    public PollChangedEndpointsHotSwapService(int endpointHotReloadPollInterval) {
        this.endpointHotReloadPollInterval = endpointHotReloadPollInterval;
    }

    @Override
    public void monitorChanges(Path buildDir, BrowserLiveReload browserLiveReload) {
        this.browserLiveReload = browserLiveReload;
        this.buildDir = buildDir;
        this.pollEndpoints();
    }

    private void pollEndpoints() {
        this.debug("Initializing the polling thread for detecting endpoint(s) changes...");
        ExecutorStatus status = this.initializeExecutorStatus();
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(() -> {
            try {
                ParserProcessor parserProcessor = new ParserProcessor(status.engineConfiguration, this.getClass().getClassLoader(), false);
                String newOpenAPI = parserProcessor.createOpenAPI();
                if (status.openAPI == null) {
                    status.openAPI = newOpenAPI;
                } else if (!status.openAPI.equals(newOpenAPI)) {
                    status.openAPI = newOpenAPI;
                    this.fireEndpointChangedEvent();
                }
            }
            catch (Throwable e) {
                this.error("Error while polling for endpoint(s) changes: %s", e.getMessage());
                e.printStackTrace();
            }
        }, 0L, this.endpointHotReloadPollInterval, TimeUnit.SECONDS);
        this.debug("for detecting endpoint(s) changes initialized.");
        Runtime.getRuntime().addShutdownHook(new Thread(executor::shutdown));
    }

    private void fireEndpointChangedEvent() {
        this.debug("Endpoint change(s) detected...");
        HotSwapListener.EndpointChangedEvent event = new HotSwapListener.EndpointChangedEvent(this.buildDir, this.browserLiveReload);
        this.hotSwapListeners.forEach(listener -> listener.endpointChanged(event));
    }

    private ExecutorStatus initializeExecutorStatus() {
        ExecutorStatus status = new ExecutorStatus();
        try {
            status.engineConfiguration = EngineConfiguration.loadDirectory((Path)this.buildDir);
            status.engineConfiguration.getParser().setPackages(List.of());
            return status;
        }
        catch (IOException e) {
            this.error("Could not load the engine configuration from %s", this.buildDir);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Registration addHotSwapListener(HotSwapListener listener) {
        return Registration.addAndRemove(this.hotSwapListeners, (Object)listener);
    }

    private void debug(String message) {
        LOGGER.debug("### Hilla Endpoint changes Poll service > " + message);
    }

    private void error(String format, Object ... params) {
        this.error(String.format(format, params));
    }

    private void error(String message) {
        LOGGER.error("### Hilla Endpoint changes Poll service > " + message);
    }

    private static class ExecutorStatus {
        EngineConfiguration engineConfiguration;
        String openAPI;

        private ExecutorStatus() {
        }
    }
}

