/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.maven;

import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import com.vaadin.hilla.engine.EngineConfiguration;
import com.vaadin.hilla.engine.GeneratorException;
import com.vaadin.hilla.engine.GeneratorProcessor;
import com.vaadin.hilla.engine.ParserException;
import com.vaadin.hilla.engine.ParserProcessor;
import com.vaadin.hilla.maven.EngineGenerateMojoException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(goal="configure")
public final class EngineGenerateMojo
extends AbstractMojo {
    @Parameter(defaultValue="node")
    private String nodeCommand;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws EngineGenerateMojoException {
        if (!FlowModeAbstractMojo.isHillaAvailable((MavenProject)this.project)) {
            this.getLog().warn((CharSequence)"The 'generate' goal is only meant to be used in Hilla projects with endpoints.\n".stripIndent());
            return;
        }
        try {
            Path baseDir = this.project.getBasedir().toPath();
            Path buildDir = baseDir.resolve(this.project.getBuild().getDirectory());
            EngineConfiguration conf = Objects.requireNonNull(EngineConfiguration.loadDirectory((Path)buildDir));
            Set classPath = conf.getClassPath();
            ArrayList<URL> urls = new ArrayList<URL>(classPath.size());
            for (Path classPathItem : classPath) {
                urls.add(classPathItem.toUri().toURL());
            }
            URLClassLoader classLoader = new URLClassLoader((URL[])urls.toArray(URL[]::new), ((Object)((Object)this)).getClass().getClassLoader());
            boolean isProduction = this.project.getActiveProfiles().stream().map(Profile::getId).anyMatch("production"::equals);
            ParserProcessor parserProcessor = new ParserProcessor(conf, (ClassLoader)classLoader, isProduction);
            GeneratorProcessor generatorProcessor = new GeneratorProcessor(conf, this.nodeCommand, isProduction);
            parserProcessor.process();
            generatorProcessor.process();
        }
        catch (IOException e) {
            throw new EngineGenerateMojoException("Loading saved configuration failed", e);
        }
        catch (GeneratorException | ParserException e) {
            throw new EngineGenerateMojoException("Execution failed", e);
        }
    }
}

