/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.pro.licensechecker.Product;
import com.vaadin.pro.licensechecker.SystemBrowser;
import com.vaadin.pro.licensechecker.Util;
import java.awt.HeadlessException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VaadinComIntegration {
    private static final String BASE_URL = "https://vaadin.com/pro/validate-license";
    private static final String MANUAL_PRO_KEY_URL = "https://vaadin.com/pro/validate-license";

    public static ProKey openBrowserAndWaitForKey(Product product) {
        String uniqueId = UUID.randomUUID().toString();
        String loginUrl = VaadinComIntegration.constructUrl(uniqueId, product);
        try {
            VaadinComIntegration.getLogger().info("Opening system browser to validate license. If the browser is not opened, please open " + loginUrl + " manually");
            SystemBrowser.open(loginUrl);
        }
        catch (HeadlessException e) {
            VaadinComIntegration.getLogger().log(Level.SEVERE, "You are running in a headless environment. Please open " + loginUrl + " in any browser to validate the license.");
        }
        catch (IOException | UnsupportedOperationException | URISyntaxException e) {
            VaadinComIntegration.getLogger().log(Level.SEVERE, "Error opening system browser to validate license. Please open " + loginUrl + " manually", e);
        }
        try {
            return VaadinComIntegration.listenForProKey("https://vaadin.com/pro/validate-license/connect/" + uniqueId);
        }
        catch (IOException e) {
            throw new RuntimeException("Error retreiving your subscription key from the server. Please try again or download the key manually from https://vaadin.com/pro/validate-license", e);
        }
    }

    public static String constructUrl(String uniqueId, Product product) {
        return "https://vaadin.com/pro/validate-license?connect=" + uniqueId + "&productName=" + product.getName() + "&productVersion=" + product.getVersion();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProKey listenForProKey(String location) throws IOException {
        Instant timeout = Instant.now().plusSeconds(60L);
        URL url = new URL(location);
        while (Instant.now().isBefore(timeout)) {
            VaadinComIntegration.getLogger().fine("Polling server for pro key");
            try (InputStream in = url.openStream();){
                String data = Util.toString(in);
                ProKey proKey = ProKey.fromJson(data);
                return proKey;
            }
            catch (FileNotFoundException e) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException throwable) {}
            }
        }
        return null;
    }

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }
}

