/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.model.style;

import com.vaadin.flow.component.charts.model.style.Color;
import com.vaadin.flow.component.charts.model.style.SolidColor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GradientColor
implements Color {
    private List<Stop> stops;
    private RadialGradient radialGradient;
    private LinearGradient linearGradient;

    private GradientColor() {
    }

    public LinearGradient getLinearGradient() {
        return this.linearGradient;
    }

    public RadialGradient getRadialGradient() {
        return this.radialGradient;
    }

    public List<Stop> getStops() {
        return this.stops;
    }

    public void addColorStop(double d, SolidColor color) {
        if (this.stops == null) {
            this.stops = new ArrayList<Stop>();
        }
        this.stops.add(new Stop(d, color));
    }

    public static GradientColor createLinear(double startX, double startY, double endX, double endY) {
        GradientColor ret = new GradientColor();
        ret.linearGradient = new LinearGradient(startX, startY, endX, endY);
        return ret;
    }

    public static GradientColor createRadial(double centerX, double centerY, double radius) {
        GradientColor ret = new GradientColor();
        ret.radialGradient = new RadialGradient(centerX, centerY, radius);
        return ret;
    }

    public static class LinearGradient
    implements Serializable {
        private final Number x1;
        private final Number y1;
        private final Number x2;
        private final Number y2;

        public LinearGradient(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Number getX1() {
            return this.x1;
        }

        public Number getY1() {
            return this.y1;
        }

        public Number getX2() {
            return this.x2;
        }

        public Number getY2() {
            return this.y2;
        }
    }

    public static class RadialGradient
    implements Serializable {
        private final Number cx;
        private final Number cy;
        private final Number r;

        public RadialGradient(double centerX, double centerY, double radius) {
            this.cx = centerX;
            this.cy = centerY;
            this.r = radius;
        }

        public Number getCx() {
            return this.cx;
        }

        public Number getCy() {
            return this.cy;
        }

        public Number getR() {
            return this.r;
        }
    }

    public static class Stop
    implements Serializable {
        private double position;
        private SolidColor color;

        public Stop(double position, SolidColor color) {
            this.position = position;
            this.color = color;
        }

        public double getPosition() {
            return this.position;
        }

        public SolidColor getColor() {
            return this.color;
        }
    }
}

