/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.editor;

public enum ComponentType {
    BUTTON("com.vaadin.flow.component.button.Button"),
    TEXTFIELD("com.vaadin.flow.component.textfield.TextField");

    private String className;

    public static ComponentType getForClass(Class<?> name) {
        for (ComponentType type : ComponentType.values()) {
            if (!type.getClassName().equals(name.getName())) continue;
            return type;
        }
        return null;
    }

    private ComponentType(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public static ComponentType from(String componentType) {
        if (componentType.equalsIgnoreCase("button")) {
            return BUTTON;
        }
        if (componentType.equalsIgnoreCase("textfield")) {
            return TEXTFIELD;
        }
        return null;
    }
}

