/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.osgi.servlet;

import com.vaadin.osgi.resources.OsgiVaadinResources;
import com.vaadin.osgi.resources.VaadinResourceService;
import com.vaadin.server.VaadinServlet;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.annotation.WebServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.log.LogService;

@Component
public class VaadinServletRegistration {
    private final Map<ServiceReference<VaadinServlet>, ServiceRegistration<Servlet>> registeredServlets = Collections.synchronizedMap(new LinkedHashMap());
    private static final String MISSING_ANNOTATION_MESSAGE_FORMAT = "The property '%s' must be set in a '%s' without the '%s' annotation!";
    private static final String URL_PATTERNS_NOT_SET_MESSAGE_FORMAT = "The property '%s' must be set when the 'urlPatterns' attribute is not set!";
    private static final String SERVLET_PATTERN = "osgi.http.whiteboard.servlet.pattern";
    private static final String VAADIN_RESOURCES_PARAM = "servlet.init.Resources";
    private LogService logService;

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, service=VaadinServlet.class, policy=ReferencePolicy.DYNAMIC)
    void bindVaadinServlet(VaadinServlet servlet, ServiceReference<VaadinServlet> reference) throws OsgiVaadinResources.ResourceBundleInactiveException {
        this.log(3, "VaadinServlet Registration");
        Hashtable<String, Object> properties = this.getProperties(reference);
        WebServlet annotation = servlet.getClass().getAnnotation(WebServlet.class);
        if (!this.validateSettings(annotation, properties)) {
            return;
        }
        properties.put(VAADIN_RESOURCES_PARAM, this.getResourcePath());
        if (annotation != null) {
            properties.put("osgi.http.whiteboard.servlet.asyncSupported", Boolean.toString(annotation.asyncSupported()));
        }
        BundleContext bundleContext = reference.getBundle().getBundleContext();
        ServiceRegistration servletRegistration = bundleContext.registerService(Servlet.class, (Object)servlet, properties);
        this.registeredServlets.put(reference, (ServiceRegistration<Servlet>)servletRegistration);
    }

    private boolean validateSettings(WebServlet annotation, Hashtable<String, Object> properties) {
        if (!properties.containsKey(SERVLET_PATTERN)) {
            if (annotation == null) {
                this.log(1, String.format(MISSING_ANNOTATION_MESSAGE_FORMAT, SERVLET_PATTERN, VaadinServlet.class.getSimpleName(), WebServlet.class.getName()));
                return false;
            }
            if (annotation.urlPatterns().length == 0) {
                this.log(1, String.format(URL_PATTERNS_NOT_SET_MESSAGE_FORMAT, SERVLET_PATTERN));
                return false;
            }
        }
        return true;
    }

    private String getResourcePath() throws OsgiVaadinResources.ResourceBundleInactiveException {
        VaadinResourceService service = OsgiVaadinResources.getService();
        return String.format("/%s", service.getResourcePathPrefix());
    }

    private void log(int level, String message) {
        if (this.logService != null) {
            this.logService.log(level, message);
        }
    }

    void unbindVaadinServlet(ServiceReference<VaadinServlet> reference) {
        ServiceRegistration<Servlet> servletRegistration = this.registeredServlets.remove(reference);
        if (servletRegistration != null) {
            try {
                servletRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    void setLogService(LogService logService) {
        this.logService = logService;
    }

    void unsetLogService(LogService logService) {
        this.logService = null;
    }

    private Hashtable<String, Object> getProperties(ServiceReference<VaadinServlet> reference) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        for (String key : reference.getPropertyKeys()) {
            properties.put(key, reference.getProperty(key));
        }
        return properties;
    }
}

