/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import java.util.function.Function;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class AuthenticationUtil {
    public static Authentication getSecurityHolderAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof AnonymousAuthenticationToken) {
            return null;
        }
        return authentication;
    }

    public static Function<String, Boolean> getSecurityHolderRoleChecker() {
        return AuthenticationUtil.getSecurityHolderRoleChecker("ROLE_");
    }

    public static Function<String, Boolean> getSecurityHolderRoleChecker(String rolePrefix) {
        Authentication authentication = AuthenticationUtil.getSecurityHolderAuthentication();
        if (authentication == null) {
            return role -> false;
        }
        return role -> {
            Object roleWithPrefix = rolePrefix != null && role != null && !role.startsWith(rolePrefix) ? rolePrefix + role : role;
            return authentication.getAuthorities().stream().anyMatch(arg_0 -> AuthenticationUtil.lambda$getSecurityHolderRoleChecker$1((String)roleWithPrefix, arg_0));
        };
    }

    private static /* synthetic */ boolean lambda$getSecurityHolderRoleChecker$1(String roleWithPrefix, GrantedAuthority grantedAuthority) {
        return grantedAuthority.getAuthority().equals(roleWithPrefix);
    }
}

