/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.spring.internal;

import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.spring.internal.BeanStore;
import com.vaadin.spring.internal.SessionLockingBeanStore;
import com.vaadin.spring.internal.ViewCache;
import com.vaadin.spring.navigator.SpringNavigator;
import com.vaadin.spring.navigator.ViewActivationListener;
import com.vaadin.ui.UI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DefaultViewCache
implements ViewCache {
    private static final long serialVersionUID = 4634842615905376953L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultViewCache.class);
    private Map<String, ViewBeanStore> beanStores = new HashMap<String, ViewBeanStore>();
    private String viewUnderConstruction = null;
    private ViewBeanStore oldViewBeanStore = null;
    private ViewBeanStore newViewBeanStore = null;
    private String activeView = null;
    private ViewActivationListener listener;

    public DefaultViewCache() {
        Navigator navigator = this.getCurrentUI().getNavigator();
        if (navigator instanceof SpringNavigator) {
            this.listener = new ViewActivationListener(){

                @Override
                public void viewActivated(ViewActivationListener.ViewActivationEvent event) {
                    if (!event.isActivated()) {
                        DefaultViewCache.this.viewDeactivated(event.getViewName());
                    } else {
                        DefaultViewCache.this.viewActivated(event.getViewName());
                    }
                }
            };
            ((SpringNavigator)navigator).addViewActivationListener(this.listener);
        } else {
            LOGGER.warn("The Navigator used does not extend SpringNavigator. View scope support may be limited, and future versions of Vaadin Spring may remove support for using a plain Navigator.");
        }
    }

    @Override
    public void creatingView(String viewName) {
        LOGGER.trace("Creating view [{}] in cache [{}]", (Object)viewName, (Object)this);
        this.oldViewBeanStore = this.beanStores.get(viewName);
        if (this.oldViewBeanStore != null) {
            this.beanStores.remove(viewName);
        }
        this.getOrCreateBeanStore(viewName);
        this.viewUnderConstruction = viewName;
    }

    @Override
    public void viewCreated(String viewName, View viewInstance) {
        LOGGER.trace("View [{}] created in cache [{}]", (Object)viewName, (Object)this);
        this.viewUnderConstruction = null;
        ViewBeanStore beanStore = this.getOrCreateBeanStore(viewName);
        if (viewInstance == null) {
            LOGGER.trace("There was a problem creating the view [{}] in cache [{}], destroying its bean store and restoring the old one (if any)", (Object)viewName, (Object)this);
            beanStore.destroy();
            beanStore = null;
        }
        this.newViewBeanStore = beanStore;
        if (this.oldViewBeanStore != null) {
            this.beanStores.put(viewName, this.oldViewBeanStore);
        } else {
            this.beanStores.remove(viewName);
        }
        this.oldViewBeanStore = null;
    }

    private void viewActivated(String viewName) {
        LOGGER.trace("View [{}] activated in cache [{}]", (Object)viewName, (Object)this);
        this.activeView = viewName;
        if (this.newViewBeanStore != null && viewName.equals(this.newViewBeanStore.viewName)) {
            this.beanStores.put(viewName, this.newViewBeanStore);
        }
        this.newViewBeanStore = null;
    }

    private void viewDeactivated(String viewName) {
        ViewBeanStore beanStore;
        LOGGER.trace("View [{}] deactivated in cache [{}], cleaning up view scoped bean stores", (Object)viewName, (Object)this);
        if (viewName.equals(this.activeView)) {
            this.activeView = null;
        }
        if ((beanStore = this.beanStores.get(viewName)) != null) {
            beanStore.destroy();
        }
        LOGGER.trace("Bean stores stored in cache [{}]: {}", (Object)this, (Object)this.beanStores.size());
    }

    @Override
    public BeanStore getCurrentViewBeanStore() {
        if (this.viewUnderConstruction != null) {
            LOGGER.trace("Currently the view [{}] is under construction in cache [{}], returning its bean store", (Object)this.viewUnderConstruction, (Object)this);
            return this.getBeanStore(this.viewUnderConstruction);
        }
        if (this.activeView != null) {
            LOGGER.trace("Currently the view [{}] is active in cache [{}], returning its bean store", (Object)this.activeView, (Object)this);
            return this.getBeanStore(this.activeView);
        }
        throw new IllegalStateException("No active view");
    }

    @PreDestroy
    void destroy() {
        Navigator navigator;
        LOGGER.trace("View cache [{}] has been destroyed, destroying all bean stores");
        for (ViewBeanStore beanStore : new HashSet<ViewBeanStore>(this.beanStores.values())) {
            beanStore.destroy();
        }
        UI currentUi = this.getCurrentUI();
        if (currentUi != null && (navigator = currentUi.getNavigator()) instanceof SpringNavigator) {
            ((SpringNavigator)navigator).removeViewActivationListener(this.listener);
        }
        Assert.isTrue((boolean)this.beanStores.isEmpty(), (String)"beanStores should have been emptied by the destruction callbacks");
    }

    private ViewBeanStore getOrCreateBeanStore(final String viewName) {
        ViewBeanStore beanStore = this.beanStores.get(viewName);
        if (beanStore == null) {
            UI ui = this.getCurrentUI();
            if (ui == null) {
                throw new IllegalStateException("No UI bound to current thread");
            }
            beanStore = new ViewBeanStore(ui, viewName, new BeanStore.DestructionCallback(){
                private static final long serialVersionUID = 5580606280246825742L;

                @Override
                public void beanStoreDestroyed(BeanStore beanStore) {
                    DefaultViewCache.this.beanStores.remove(viewName);
                }
            });
            this.beanStores.put(viewName, beanStore);
        }
        return beanStore;
    }

    private UI getCurrentUI() {
        return UI.getCurrent();
    }

    private ViewBeanStore getBeanStore(String viewName) {
        ViewBeanStore beanStore = this.beanStores.get(viewName);
        if (beanStore == null) {
            throw new IllegalStateException("The view " + viewName + " has not been created");
        }
        return beanStore;
    }

    class ViewBeanStore
    extends SessionLockingBeanStore
    implements ViewChangeListener {
        private static final long serialVersionUID = -7655740852919880134L;
        private final String viewName;
        private final Navigator navigator;

        ViewBeanStore(UI ui, String viewName, BeanStore.DestructionCallback destructionCallback) {
            super(ui.getSession(), ui.getId() + ":" + viewName, destructionCallback);
            this.viewName = viewName;
            this.navigator = ui.getNavigator();
            if (this.navigator == null) {
                throw new IllegalStateException("UI has no Navigator");
            }
            if (!(this.navigator instanceof SpringNavigator)) {
                LOGGER.trace("Adding [{}} as view change listener to [{}]", (Object)this, (Object)this.navigator);
                this.navigator.addViewChangeListener((ViewChangeListener)this);
            }
        }

        @Override
        public void destroy() {
            if (!(this.navigator instanceof SpringNavigator)) {
                LOGGER.trace("Removing [{}] as view change listener from [{}]", (Object)this, (Object)this.navigator);
                this.navigator.removeViewChangeListener((ViewChangeListener)this);
            }
            super.destroy();
        }

        public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
            return true;
        }

        public void afterViewChange(ViewChangeListener.ViewChangeEvent viewChangeEvent) {
            if (this.viewName.equals(viewChangeEvent.getViewName())) {
                DefaultViewCache.this.viewActivated(this.viewName);
            } else {
                DefaultViewCache.this.viewDeactivated(this.viewName);
            }
        }
    }
}

