/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage;

import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.storage.GraphStorageConnection;
import com.vesoft.nebula.client.storage.StorageConnPoolFactory;
import com.vesoft.nebula.client.storage.StoragePoolConfig;
import java.io.Serializable;
import org.apache.flink.connector.nebula.shaded.org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.flink.connector.nebula.shaded.org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.flink.connector.nebula.shaded.org.slf4j.Logger;
import org.apache.flink.connector.nebula.shaded.org.slf4j.LoggerFactory;

public class StorageConnPool
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageConnPool.class);
    private static final long serialVersionUID = -6459633350295900558L;
    private final GenericKeyedObjectPool<HostAddress, GraphStorageConnection> keyedPool;
    private final StorageConnPoolFactory poolFactory;

    public StorageConnPool(StoragePoolConfig config) {
        this.poolFactory = new StorageConnPoolFactory(config);
        GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
        poolConfig.setMaxIdlePerKey(config.getMaxConnsSize());
        poolConfig.setMinIdlePerKey(config.getMinConnsSize());
        poolConfig.setMinEvictableIdleTimeMillis(config.getIdleTime() <= 0 ? Long.MAX_VALUE : (long)config.getIdleTime());
        poolConfig.setMaxTotal(config.getMaxTotal());
        poolConfig.setMaxTotalPerKey(config.getMaxTotalPerKey());
        this.keyedPool = new GenericKeyedObjectPool<HostAddress, GraphStorageConnection>(this.poolFactory);
        this.keyedPool.setConfig(poolConfig);
    }

    public void close() {
        this.keyedPool.close();
    }

    public GraphStorageConnection getStorageConnection(HostAddress address) throws Exception {
        return this.keyedPool.borrowObject(address);
    }

    public void release(HostAddress address, GraphStorageConnection connection) {
        this.keyedPool.returnObject(address, connection);
    }

    public int getNumActive(HostAddress address) {
        return this.keyedPool.getNumActive(address);
    }

    public int get(HostAddress address) {
        return this.keyedPool.getNumIdle(address);
    }
}

