/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.graph;

import com.vesoft.nebula.ErrorCode;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBase;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBaseHelper;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldValueMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TField;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolUtil;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TStruct;

public class AuthResponse
implements TBase,
Serializable,
Cloneable,
Comparable<AuthResponse> {
    private static final TStruct STRUCT_DESC = new TStruct("AuthResponse");
    private static final TField ERROR_CODE_FIELD_DESC = new TField("error_code", 8, 1);
    private static final TField ERROR_MSG_FIELD_DESC = new TField("error_msg", 11, 2);
    private static final TField SESSION_ID_FIELD_DESC = new TField("session_id", 10, 3);
    private static final TField TIME_ZONE_OFFSET_SECONDS_FIELD_DESC = new TField("time_zone_offset_seconds", 8, 4);
    private static final TField TIME_ZONE_NAME_FIELD_DESC = new TField("time_zone_name", 11, 5);
    public ErrorCode error_code;
    public byte[] error_msg;
    public long session_id;
    public int time_zone_offset_seconds;
    public byte[] time_zone_name;
    public static final int ERROR_CODE = 1;
    public static final int ERROR_MSG = 2;
    public static final int SESSION_ID = 3;
    public static final int TIME_ZONE_OFFSET_SECONDS = 4;
    public static final int TIME_ZONE_NAME = 5;
    private static final int __SESSION_ID_ISSET_ID = 0;
    private static final int __TIME_ZONE_OFFSET_SECONDS_ISSET_ID = 1;
    private BitSet __isset_bit_vector = new BitSet(2);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public AuthResponse() {
    }

    public AuthResponse(ErrorCode error_code) {
        this();
        this.error_code = error_code;
    }

    public AuthResponse(ErrorCode error_code, byte[] error_msg, long session_id, int time_zone_offset_seconds, byte[] time_zone_name) {
        this();
        this.error_code = error_code;
        this.error_msg = error_msg;
        this.session_id = session_id;
        this.setSession_idIsSet(true);
        this.time_zone_offset_seconds = time_zone_offset_seconds;
        this.setTime_zone_offset_secondsIsSet(true);
        this.time_zone_name = time_zone_name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AuthResponse(AuthResponse other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        if (other.isSetError_code()) {
            this.error_code = TBaseHelper.deepCopy(other.error_code);
        }
        if (other.isSetError_msg()) {
            this.error_msg = TBaseHelper.deepCopy(other.error_msg);
        }
        this.session_id = TBaseHelper.deepCopy(other.session_id);
        this.time_zone_offset_seconds = TBaseHelper.deepCopy(other.time_zone_offset_seconds);
        if (other.isSetTime_zone_name()) {
            this.time_zone_name = TBaseHelper.deepCopy(other.time_zone_name);
        }
    }

    @Override
    public AuthResponse deepCopy() {
        return new AuthResponse(this);
    }

    public ErrorCode getError_code() {
        return this.error_code;
    }

    public AuthResponse setError_code(ErrorCode error_code) {
        this.error_code = error_code;
        return this;
    }

    public void unsetError_code() {
        this.error_code = null;
    }

    public boolean isSetError_code() {
        return this.error_code != null;
    }

    public void setError_codeIsSet(boolean __value) {
        if (!__value) {
            this.error_code = null;
        }
    }

    public byte[] getError_msg() {
        return this.error_msg;
    }

    public AuthResponse setError_msg(byte[] error_msg) {
        this.error_msg = error_msg;
        return this;
    }

    public void unsetError_msg() {
        this.error_msg = null;
    }

    public boolean isSetError_msg() {
        return this.error_msg != null;
    }

    public void setError_msgIsSet(boolean __value) {
        if (!__value) {
            this.error_msg = null;
        }
    }

    public long getSession_id() {
        return this.session_id;
    }

    public AuthResponse setSession_id(long session_id) {
        this.session_id = session_id;
        this.setSession_idIsSet(true);
        return this;
    }

    public void unsetSession_id() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetSession_id() {
        return this.__isset_bit_vector.get(0);
    }

    public void setSession_idIsSet(boolean __value) {
        this.__isset_bit_vector.set(0, __value);
    }

    public int getTime_zone_offset_seconds() {
        return this.time_zone_offset_seconds;
    }

    public AuthResponse setTime_zone_offset_seconds(int time_zone_offset_seconds) {
        this.time_zone_offset_seconds = time_zone_offset_seconds;
        this.setTime_zone_offset_secondsIsSet(true);
        return this;
    }

    public void unsetTime_zone_offset_seconds() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetTime_zone_offset_seconds() {
        return this.__isset_bit_vector.get(1);
    }

    public void setTime_zone_offset_secondsIsSet(boolean __value) {
        this.__isset_bit_vector.set(1, __value);
    }

    public byte[] getTime_zone_name() {
        return this.time_zone_name;
    }

    public AuthResponse setTime_zone_name(byte[] time_zone_name) {
        this.time_zone_name = time_zone_name;
        return this;
    }

    public void unsetTime_zone_name() {
        this.time_zone_name = null;
    }

    public boolean isSetTime_zone_name() {
        return this.time_zone_name != null;
    }

    public void setTime_zone_nameIsSet(boolean __value) {
        if (!__value) {
            this.time_zone_name = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetError_code();
                    break;
                }
                this.setError_code((ErrorCode)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetError_msg();
                    break;
                }
                this.setError_msg((byte[])__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetSession_id();
                    break;
                }
                this.setSession_id((Long)__value);
                break;
            }
            case 4: {
                if (__value == null) {
                    this.unsetTime_zone_offset_seconds();
                    break;
                }
                this.setTime_zone_offset_seconds((Integer)__value);
                break;
            }
            case 5: {
                if (__value == null) {
                    this.unsetTime_zone_name();
                    break;
                }
                this.setTime_zone_name((byte[])__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getError_code();
            }
            case 2: {
                return this.getError_msg();
            }
            case 3: {
                return new Long(this.getSession_id());
            }
            case 4: {
                return new Integer(this.getTime_zone_offset_seconds());
            }
            case 5: {
                return this.getTime_zone_name();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof AuthResponse)) {
            return false;
        }
        AuthResponse that = (AuthResponse)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetError_code(), that.isSetError_code(), this.error_code, that.error_code)) {
            return false;
        }
        if (!TBaseHelper.equalsSlow(this.isSetError_msg(), that.isSetError_msg(), this.error_msg, that.error_msg)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetSession_id(), that.isSetSession_id(), this.session_id, that.session_id)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetTime_zone_offset_seconds(), that.isSetTime_zone_offset_seconds(), this.time_zone_offset_seconds, that.time_zone_offset_seconds)) {
            return false;
        }
        return TBaseHelper.equalsSlow(this.isSetTime_zone_name(), that.isSetTime_zone_name(), this.time_zone_name, that.time_zone_name);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.error_code, this.error_msg, this.session_id, this.time_zone_offset_seconds, this.time_zone_name});
    }

    @Override
    public int compareTo(AuthResponse other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetError_code()).compareTo(other.isSetError_code());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.error_code, other.error_code);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetError_msg()).compareTo(other.isSetError_msg());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.error_msg, other.error_msg);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSession_id()).compareTo(other.isSetSession_id());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.session_id, other.session_id);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTime_zone_offset_seconds()).compareTo(other.isSetTime_zone_offset_seconds());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.time_zone_offset_seconds, other.time_zone_offset_seconds);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTime_zone_name()).compareTo(other.isSetTime_zone_name());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.time_zone_name, other.time_zone_name);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.error_code = ErrorCode.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 11) {
                        this.error_msg = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 10) {
                        this.session_id = iprot.readI64();
                        this.setSession_idIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 4: {
                    if (__field.type == 8) {
                        this.time_zone_offset_seconds = iprot.readI32();
                        this.setTime_zone_offset_secondsIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 5: {
                    if (__field.type == 11) {
                        this.time_zone_name = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.error_code != null) {
            oprot.writeFieldBegin(ERROR_CODE_FIELD_DESC);
            oprot.writeI32(this.error_code == null ? 0 : this.error_code.getValue());
            oprot.writeFieldEnd();
        }
        if (this.error_msg != null && this.isSetError_msg()) {
            oprot.writeFieldBegin(ERROR_MSG_FIELD_DESC);
            oprot.writeBinary(this.error_msg);
            oprot.writeFieldEnd();
        }
        if (this.isSetSession_id()) {
            oprot.writeFieldBegin(SESSION_ID_FIELD_DESC);
            oprot.writeI64(this.session_id);
            oprot.writeFieldEnd();
        }
        if (this.isSetTime_zone_offset_seconds()) {
            oprot.writeFieldBegin(TIME_ZONE_OFFSET_SECONDS_FIELD_DESC);
            oprot.writeI32(this.time_zone_offset_seconds);
            oprot.writeFieldEnd();
        }
        if (this.time_zone_name != null && this.isSetTime_zone_name()) {
            oprot.writeFieldBegin(TIME_ZONE_NAME_FIELD_DESC);
            oprot.writeBinary(this.time_zone_name);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        int i;
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("AuthResponse");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("error_code");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getError_code() == null) {
            sb.append("null");
        } else {
            String error_code_name;
            String string = error_code_name = this.getError_code() == null ? "null" : this.getError_code().name();
            if (error_code_name != null) {
                sb.append(error_code_name);
                sb.append(" (");
            }
            sb.append(this.getError_code());
            if (error_code_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (this.isSetError_msg()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("error_msg");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getError_msg() == null) {
                sb.append("null");
            } else {
                int __error_msg_size = Math.min(this.getError_msg().length, 128);
                for (i = 0; i < __error_msg_size; ++i) {
                    if (i != 0) {
                        sb.append(" ");
                    }
                    sb.append(Integer.toHexString(this.getError_msg()[i]).length() > 1 ? Integer.toHexString(this.getError_msg()[i]).substring(Integer.toHexString(this.getError_msg()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getError_msg()[i]).toUpperCase());
                }
                if (this.getError_msg().length > 128) {
                    sb.append(" ...");
                }
            }
            first = false;
        }
        if (this.isSetSession_id()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("session_id");
            sb.append(space);
            sb.append(":").append(space);
            sb.append(TBaseHelper.toString(this.getSession_id(), indent + 1, prettyPrint));
            first = false;
        }
        if (this.isSetTime_zone_offset_seconds()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("time_zone_offset_seconds");
            sb.append(space);
            sb.append(":").append(space);
            sb.append(TBaseHelper.toString(this.getTime_zone_offset_seconds(), indent + 1, prettyPrint));
            first = false;
        }
        if (this.isSetTime_zone_name()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("time_zone_name");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getTime_zone_name() == null) {
                sb.append("null");
            } else {
                int __time_zone_name_size = Math.min(this.getTime_zone_name().length, 128);
                for (i = 0; i < __time_zone_name_size; ++i) {
                    if (i != 0) {
                        sb.append(" ");
                    }
                    sb.append(Integer.toHexString(this.getTime_zone_name()[i]).length() > 1 ? Integer.toHexString(this.getTime_zone_name()[i]).substring(Integer.toHexString(this.getTime_zone_name()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getTime_zone_name()[i]).toUpperCase());
                }
                if (this.getTime_zone_name().length > 128) {
                    sb.append(" ...");
                }
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.error_code == null) {
            throw new TProtocolException(6, "Required field 'error_code' was not present! Struct: " + this.toString());
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("error_code", 1, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("error_msg", 2, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(3, new FieldMetaData("session_id", 2, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(4, new FieldMetaData("time_zone_offset_seconds", 2, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(5, new FieldMetaData("time_zone_name", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(AuthResponse.class, metaDataMap);
    }

    public static class Builder {
        private ErrorCode error_code;
        private byte[] error_msg;
        private long session_id;
        private int time_zone_offset_seconds;
        private byte[] time_zone_name;
        BitSet __optional_isset = new BitSet(2);

        public Builder setError_code(ErrorCode error_code) {
            this.error_code = error_code;
            return this;
        }

        public Builder setError_msg(byte[] error_msg) {
            this.error_msg = error_msg;
            return this;
        }

        public Builder setSession_id(long session_id) {
            this.session_id = session_id;
            this.__optional_isset.set(0, true);
            return this;
        }

        public Builder setTime_zone_offset_seconds(int time_zone_offset_seconds) {
            this.time_zone_offset_seconds = time_zone_offset_seconds;
            this.__optional_isset.set(1, true);
            return this;
        }

        public Builder setTime_zone_name(byte[] time_zone_name) {
            this.time_zone_name = time_zone_name;
            return this;
        }

        public AuthResponse build() {
            AuthResponse result = new AuthResponse();
            result.setError_code(this.error_code);
            result.setError_msg(this.error_msg);
            if (this.__optional_isset.get(0)) {
                result.setSession_id(this.session_id);
            }
            if (this.__optional_isset.get(1)) {
                result.setTime_zone_offset_seconds(this.time_zone_offset_seconds);
            }
            result.setTime_zone_name(this.time_zone_name);
            return result;
        }
    }
}

