/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.graph;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBase;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBaseHelper;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldValueMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TField;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolUtil;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TStruct;

public class Pair
implements TBase,
Serializable,
Cloneable,
Comparable<Pair> {
    private static final TStruct STRUCT_DESC = new TStruct("Pair");
    private static final TField KEY_FIELD_DESC = new TField("key", 11, 1);
    private static final TField VALUE_FIELD_DESC = new TField("value", 11, 2);
    public byte[] key;
    public byte[] value;
    public static final int KEY = 1;
    public static final int VALUE = 2;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public Pair() {
    }

    public Pair(byte[] key, byte[] value) {
        this();
        this.key = key;
        this.value = value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Pair(Pair other) {
        if (other.isSetKey()) {
            this.key = TBaseHelper.deepCopy(other.key);
        }
        if (other.isSetValue()) {
            this.value = TBaseHelper.deepCopy(other.value);
        }
    }

    @Override
    public Pair deepCopy() {
        return new Pair(this);
    }

    public byte[] getKey() {
        return this.key;
    }

    public Pair setKey(byte[] key) {
        this.key = key;
        return this;
    }

    public void unsetKey() {
        this.key = null;
    }

    public boolean isSetKey() {
        return this.key != null;
    }

    public void setKeyIsSet(boolean __value) {
        if (!__value) {
            this.key = null;
        }
    }

    public byte[] getValue() {
        return this.value;
    }

    public Pair setValue(byte[] value) {
        this.value = value;
        return this;
    }

    public void unsetValue() {
        this.value = null;
    }

    public boolean isSetValue() {
        return this.value != null;
    }

    public void setValueIsSet(boolean __value) {
        if (!__value) {
            this.value = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetKey();
                    break;
                }
                this.setKey((byte[])__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetValue();
                    break;
                }
                this.setValue((byte[])__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getKey();
            }
            case 2: {
                return this.getValue();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof Pair)) {
            return false;
        }
        Pair that = (Pair)_that;
        if (!TBaseHelper.equalsSlow(this.isSetKey(), that.isSetKey(), this.key, that.key)) {
            return false;
        }
        return TBaseHelper.equalsSlow(this.isSetValue(), that.isSetValue(), this.value, that.value);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.key, this.value});
    }

    @Override
    public int compareTo(Pair other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetKey()).compareTo(other.isSetKey());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.key, other.key);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetValue()).compareTo(other.isSetValue());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.value, other.value);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 11) {
                        this.key = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 11) {
                        this.value = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.key != null) {
            oprot.writeFieldBegin(KEY_FIELD_DESC);
            oprot.writeBinary(this.key);
            oprot.writeFieldEnd();
        }
        if (this.value != null) {
            oprot.writeFieldBegin(VALUE_FIELD_DESC);
            oprot.writeBinary(this.value);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        int i;
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("Pair");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("key");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getKey() == null) {
            sb.append("null");
        } else {
            int __key_size = Math.min(this.getKey().length, 128);
            for (i = 0; i < __key_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getKey()[i]).length() > 1 ? Integer.toHexString(this.getKey()[i]).substring(Integer.toHexString(this.getKey()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getKey()[i]).toUpperCase());
            }
            if (this.getKey().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("value");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getValue() == null) {
            sb.append("null");
        } else {
            int __value_size = Math.min(this.getValue().length, 128);
            for (i = 0; i < __value_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getValue()[i]).length() > 1 ? Integer.toHexString(this.getValue()[i]).substring(Integer.toHexString(this.getValue()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getValue()[i]).toUpperCase());
            }
            if (this.getValue().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.key == null) {
            throw new TProtocolException(6, "Required field 'key' was not present! Struct: " + this.toString());
        }
        if (this.value == null) {
            throw new TProtocolException(6, "Required field 'value' was not present! Struct: " + this.toString());
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("key", 1, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(2, new FieldMetaData("value", 1, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(Pair.class, metaDataMap);
    }

    public static class Builder {
        private byte[] key;
        private byte[] value;

        public Builder setKey(byte[] key) {
            this.key = key;
            return this;
        }

        public Builder setValue(byte[] value) {
            this.value = value;
            return this;
        }

        public Pair build() {
            Pair result = new Pair();
            result.setKey(this.key);
            result.setValue(this.value);
            return result;
        }
    }
}

