/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.vesoft.nebula.meta.ConfigModule;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBase;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBaseHelper;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldValueMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TField;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolUtil;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TStruct;

public class ListConfigsReq
implements TBase,
Serializable,
Cloneable,
Comparable<ListConfigsReq> {
    private static final TStruct STRUCT_DESC = new TStruct("ListConfigsReq");
    private static final TField SPACE_FIELD_DESC = new TField("space", 11, 1);
    private static final TField MODULE_FIELD_DESC = new TField("module", 8, 2);
    public byte[] space;
    public ConfigModule module;
    public static final int SPACE = 1;
    public static final int MODULE = 2;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public ListConfigsReq() {
    }

    public ListConfigsReq(byte[] space, ConfigModule module) {
        this();
        this.space = space;
        this.module = module;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListConfigsReq(ListConfigsReq other) {
        if (other.isSetSpace()) {
            this.space = TBaseHelper.deepCopy(other.space);
        }
        if (other.isSetModule()) {
            this.module = TBaseHelper.deepCopy(other.module);
        }
    }

    @Override
    public ListConfigsReq deepCopy() {
        return new ListConfigsReq(this);
    }

    public byte[] getSpace() {
        return this.space;
    }

    public ListConfigsReq setSpace(byte[] space) {
        this.space = space;
        return this;
    }

    public void unsetSpace() {
        this.space = null;
    }

    public boolean isSetSpace() {
        return this.space != null;
    }

    public void setSpaceIsSet(boolean __value) {
        if (!__value) {
            this.space = null;
        }
    }

    public ConfigModule getModule() {
        return this.module;
    }

    public ListConfigsReq setModule(ConfigModule module) {
        this.module = module;
        return this;
    }

    public void unsetModule() {
        this.module = null;
    }

    public boolean isSetModule() {
        return this.module != null;
    }

    public void setModuleIsSet(boolean __value) {
        if (!__value) {
            this.module = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetSpace();
                    break;
                }
                this.setSpace((byte[])__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetModule();
                    break;
                }
                this.setModule((ConfigModule)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getSpace();
            }
            case 2: {
                return this.getModule();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof ListConfigsReq)) {
            return false;
        }
        ListConfigsReq that = (ListConfigsReq)_that;
        if (!TBaseHelper.equalsSlow(this.isSetSpace(), that.isSetSpace(), this.space, that.space)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetModule(), that.isSetModule(), this.module, that.module);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.space, this.module});
    }

    @Override
    public int compareTo(ListConfigsReq other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetSpace()).compareTo(other.isSetSpace());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.space, other.space);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetModule()).compareTo(other.isSetModule());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.module, other.module);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 11) {
                        this.space = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 8) {
                        this.module = ConfigModule.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.space != null) {
            oprot.writeFieldBegin(SPACE_FIELD_DESC);
            oprot.writeBinary(this.space);
            oprot.writeFieldEnd();
        }
        if (this.module != null) {
            oprot.writeFieldBegin(MODULE_FIELD_DESC);
            oprot.writeI32(this.module == null ? 0 : this.module.getValue());
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("ListConfigsReq");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("space");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getSpace() == null) {
            sb.append("null");
        } else {
            int __space_size = Math.min(this.getSpace().length, 128);
            for (int i = 0; i < __space_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getSpace()[i]).length() > 1 ? Integer.toHexString(this.getSpace()[i]).substring(Integer.toHexString(this.getSpace()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getSpace()[i]).toUpperCase());
            }
            if (this.getSpace().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("module");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getModule() == null) {
            sb.append("null");
        } else {
            String module_name;
            String string = module_name = this.getModule() == null ? "null" : this.getModule().name();
            if (module_name != null) {
                sb.append(module_name);
                sb.append(" (");
            }
            sb.append(this.getModule());
            if (module_name != null) {
                sb.append(")");
            }
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("space", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(2, new FieldMetaData("module", 3, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(ListConfigsReq.class, metaDataMap);
    }

    public static class Builder {
        private byte[] space;
        private ConfigModule module;

        public Builder setSpace(byte[] space) {
            this.space = space;
            return this;
        }

        public Builder setModule(ConfigModule module) {
            this.module = module;
            return this;
        }

        public ListConfigsReq build() {
            ListConfigsReq result = new ListConfigsReq();
            result.setSpace(this.space);
            result.setModule(this.module);
            return result;
        }
    }
}

