/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.vesoft.nebula.ErrorCode;
import com.vesoft.nebula.HostAddr;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBase;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBaseHelper;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldValueMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.StructMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TField;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolUtil;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TStruct;

public class SaveGraphVersionResp
implements TBase,
Serializable,
Cloneable,
Comparable<SaveGraphVersionResp> {
    private static final TStruct STRUCT_DESC = new TStruct("SaveGraphVersionResp");
    private static final TField CODE_FIELD_DESC = new TField("code", 8, 1);
    private static final TField LEADER_FIELD_DESC = new TField("leader", 12, 2);
    private static final TField ERROR_MSG_FIELD_DESC = new TField("error_msg", 11, 3);
    public ErrorCode code;
    public HostAddr leader;
    public byte[] error_msg;
    public static final int CODE = 1;
    public static final int LEADER = 2;
    public static final int ERROR_MSG = 3;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public SaveGraphVersionResp() {
    }

    public SaveGraphVersionResp(ErrorCode code, HostAddr leader) {
        this();
        this.code = code;
        this.leader = leader;
    }

    public SaveGraphVersionResp(ErrorCode code, HostAddr leader, byte[] error_msg) {
        this();
        this.code = code;
        this.leader = leader;
        this.error_msg = error_msg;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SaveGraphVersionResp(SaveGraphVersionResp other) {
        if (other.isSetCode()) {
            this.code = TBaseHelper.deepCopy(other.code);
        }
        if (other.isSetLeader()) {
            this.leader = TBaseHelper.deepCopy(other.leader);
        }
        if (other.isSetError_msg()) {
            this.error_msg = TBaseHelper.deepCopy(other.error_msg);
        }
    }

    @Override
    public SaveGraphVersionResp deepCopy() {
        return new SaveGraphVersionResp(this);
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public SaveGraphVersionResp setCode(ErrorCode code) {
        this.code = code;
        return this;
    }

    public void unsetCode() {
        this.code = null;
    }

    public boolean isSetCode() {
        return this.code != null;
    }

    public void setCodeIsSet(boolean __value) {
        if (!__value) {
            this.code = null;
        }
    }

    public HostAddr getLeader() {
        return this.leader;
    }

    public SaveGraphVersionResp setLeader(HostAddr leader) {
        this.leader = leader;
        return this;
    }

    public void unsetLeader() {
        this.leader = null;
    }

    public boolean isSetLeader() {
        return this.leader != null;
    }

    public void setLeaderIsSet(boolean __value) {
        if (!__value) {
            this.leader = null;
        }
    }

    public byte[] getError_msg() {
        return this.error_msg;
    }

    public SaveGraphVersionResp setError_msg(byte[] error_msg) {
        this.error_msg = error_msg;
        return this;
    }

    public void unsetError_msg() {
        this.error_msg = null;
    }

    public boolean isSetError_msg() {
        return this.error_msg != null;
    }

    public void setError_msgIsSet(boolean __value) {
        if (!__value) {
            this.error_msg = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetCode();
                    break;
                }
                this.setCode((ErrorCode)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetLeader();
                    break;
                }
                this.setLeader((HostAddr)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetError_msg();
                    break;
                }
                this.setError_msg((byte[])__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getCode();
            }
            case 2: {
                return this.getLeader();
            }
            case 3: {
                return this.getError_msg();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof SaveGraphVersionResp)) {
            return false;
        }
        SaveGraphVersionResp that = (SaveGraphVersionResp)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetCode(), that.isSetCode(), this.code, that.code)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetLeader(), that.isSetLeader(), this.leader, that.leader)) {
            return false;
        }
        return TBaseHelper.equalsSlow(this.isSetError_msg(), that.isSetError_msg(), this.error_msg, that.error_msg);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.code, this.leader, this.error_msg});
    }

    @Override
    public int compareTo(SaveGraphVersionResp other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetCode()).compareTo(other.isSetCode());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.code, other.code);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLeader()).compareTo(other.isSetLeader());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.leader, other.leader);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetError_msg()).compareTo(other.isSetError_msg());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.error_msg, other.error_msg);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.code = ErrorCode.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.leader = new HostAddr();
                        this.leader.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 11) {
                        this.error_msg = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.code != null) {
            oprot.writeFieldBegin(CODE_FIELD_DESC);
            oprot.writeI32(this.code == null ? 0 : this.code.getValue());
            oprot.writeFieldEnd();
        }
        if (this.leader != null) {
            oprot.writeFieldBegin(LEADER_FIELD_DESC);
            this.leader.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.error_msg != null && this.isSetError_msg()) {
            oprot.writeFieldBegin(ERROR_MSG_FIELD_DESC);
            oprot.writeBinary(this.error_msg);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("SaveGraphVersionResp");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("code");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getCode() == null) {
            sb.append("null");
        } else {
            String code_name;
            String string = code_name = this.getCode() == null ? "null" : this.getCode().name();
            if (code_name != null) {
                sb.append(code_name);
                sb.append(" (");
            }
            sb.append(this.getCode());
            if (code_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("leader");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getLeader() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getLeader(), indent + 1, prettyPrint));
        }
        first = false;
        if (this.isSetError_msg()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("error_msg");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getError_msg() == null) {
                sb.append("null");
            } else {
                int __error_msg_size = Math.min(this.getError_msg().length, 128);
                for (int i = 0; i < __error_msg_size; ++i) {
                    if (i != 0) {
                        sb.append(" ");
                    }
                    sb.append(Integer.toHexString(this.getError_msg()[i]).length() > 1 ? Integer.toHexString(this.getError_msg()[i]).substring(Integer.toHexString(this.getError_msg()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getError_msg()[i]).toUpperCase());
                }
                if (this.getError_msg().length > 128) {
                    sb.append(" ...");
                }
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("code", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("leader", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("error_msg", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(SaveGraphVersionResp.class, metaDataMap);
    }

    public static class Builder {
        private ErrorCode code;
        private HostAddr leader;
        private byte[] error_msg;

        public Builder setCode(ErrorCode code) {
            this.code = code;
            return this;
        }

        public Builder setLeader(HostAddr leader) {
            this.leader = leader;
            return this;
        }

        public Builder setError_msg(byte[] error_msg) {
            this.error_msg = error_msg;
            return this;
        }

        public SaveGraphVersionResp build() {
            SaveGraphVersionResp result = new SaveGraphVersionResp();
            result.setCode(this.code);
            result.setLeader(this.leader);
            result.setError_msg(this.error_msg);
            return result;
        }
    }
}

