/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.connection;

import com.vesoft.nebula.client.graph.data.CASignedSSLParam;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.data.SelfSignedSSLParam;
import com.vesoft.nebula.client.storage.StorageClient;
import java.io.Serializable;
import java.util.List;
import org.apache.flink.connector.nebula.connection.CASignParams;
import org.apache.flink.connector.nebula.connection.NebulaClientOptions;
import org.apache.flink.connector.nebula.connection.SelfSignParams;

public class NebulaStorageConnectionProvider
implements Serializable {
    private static final long serialVersionUID = -3822165815516596188L;
    private NebulaClientOptions nebulaClientOptions;

    public NebulaStorageConnectionProvider(NebulaClientOptions nebulaClientOptions) {
        this.nebulaClientOptions = nebulaClientOptions;
    }

    public NebulaStorageConnectionProvider() {
    }

    public StorageClient getStorageClient() throws Exception {
        StorageClient storageClient;
        block6: {
            int timeout;
            List<HostAddress> addresses;
            block5: {
                addresses = this.nebulaClientOptions.getMetaAddress();
                timeout = this.nebulaClientOptions.getTimeout();
                int retry = this.nebulaClientOptions.getConnectRetry();
                if (!this.nebulaClientOptions.isEnableStorageSSL()) break block5;
                switch (this.nebulaClientOptions.getSSLSignType()) {
                    case CA: {
                        CASignParams caSignParams = this.nebulaClientOptions.getCaSignParam();
                        CASignedSSLParam sslParam = new CASignedSSLParam(caSignParams.getCaCrtFilePath(), caSignParams.getCrtFilePath(), caSignParams.getKeyFilePath());
                        storageClient = new StorageClient(addresses, timeout, retry, retry, true, sslParam);
                        break block6;
                    }
                    case SELF: {
                        SelfSignParams selfSignParams = this.nebulaClientOptions.getSelfSignParam();
                        SelfSignedSSLParam sslParam = new SelfSignedSSLParam(selfSignParams.getCrtFilePath(), selfSignParams.getKeyFilePath(), selfSignParams.getPassword());
                        storageClient = new StorageClient(addresses, timeout, retry, retry, true, sslParam);
                        break block6;
                    }
                    default: {
                        throw new IllegalArgumentException("ssl sign type is not supported.");
                    }
                }
            }
            storageClient = new StorageClient(addresses, timeout);
        }
        if (!storageClient.connect()) {
            throw new Exception("failed to connect storaged.");
        }
        return storageClient;
    }

    public NebulaClientOptions getNebulaClientOptions() {
        return this.nebulaClientOptions;
    }

    public void setNebulaClientOptions(NebulaClientOptions nebulaClientOptions) {
        this.nebulaClientOptions = nebulaClientOptions;
    }
}

