/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.com.facebook.thrift;

public class EncodingUtils {
    public static void encodeBigEndian(int integer, byte[] buf) {
        EncodingUtils.encodeBigEndian(integer, buf, 0);
    }

    public static void encodeBigEndian(int integer, byte[] buf, int offset) {
        buf[offset] = (byte)(0xFF & integer >> 24);
        buf[offset + 1] = (byte)(0xFF & integer >> 16);
        buf[offset + 2] = (byte)(0xFF & integer >> 8);
        buf[offset + 3] = (byte)(0xFF & integer);
    }

    public static int decodeBigEndian(byte[] buf) {
        return EncodingUtils.decodeBigEndian(buf, 0);
    }

    public static int decodeBigEndian(byte[] buf, int offset) {
        return (buf[offset] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
    }

    public static boolean testBit(byte v, int position) {
        return EncodingUtils.testBit((int)v, position);
    }

    public static boolean testBit(short v, int position) {
        return EncodingUtils.testBit((int)v, position);
    }

    public static boolean testBit(int v, int position) {
        return (v & 1 << position) != 0;
    }

    public static boolean testBit(long v, int position) {
        return (v & 1L << position) != 0L;
    }

    public static byte clearBit(byte v, int position) {
        return (byte)EncodingUtils.clearBit((int)v, position);
    }

    public static short clearBit(short v, int position) {
        return (short)EncodingUtils.clearBit((int)v, position);
    }

    public static int clearBit(int v, int position) {
        return v & ~(1 << position);
    }

    public static long clearBit(long v, int position) {
        return v & (1L << position ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static byte setBit(byte v, int position, boolean value) {
        return (byte)EncodingUtils.setBit((int)v, position, value);
    }

    public static short setBit(short v, int position, boolean value) {
        return (short)EncodingUtils.setBit((int)v, position, value);
    }

    public static int setBit(int v, int position, boolean value) {
        if (value) {
            return v | 1 << position;
        }
        return EncodingUtils.clearBit(v, position);
    }

    public static long setBit(long v, int position, boolean value) {
        if (value) {
            return v | 1L << position;
        }
        return EncodingUtils.clearBit(v, position);
    }
}

