/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.com.facebook.thrift;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBase;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TProcessorEventHandler;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.server.TConnectionContext;

public class MultipleTProcessorEventHandlers
extends TProcessorEventHandler {
    private final List<TProcessorEventHandler> handlers;

    public MultipleTProcessorEventHandlers(List<TProcessorEventHandler> handlers) {
        this.handlers = handlers != null ? new ArrayList<TProcessorEventHandler>(handlers) : new ArrayList<TProcessorEventHandler>();
    }

    @Override
    public Object getContext(String fn_name, TConnectionContext context) {
        return new EventHandlerContexts(this.handlers, fn_name, context);
    }

    @Override
    public void preRead(Object handler_context, String fn_name) throws TException {
        if (handler_context != null) {
            EventHandlerContexts contexts = (EventHandlerContexts)handler_context;
            for (int i = 0; i < this.handlers.size(); ++i) {
                this.handlers.get(i).preRead(contexts.ctxs.get(i), fn_name);
            }
        }
    }

    @Override
    public void postRead(Object handler_context, String fn_name, TBase args) throws TException {
        if (handler_context != null) {
            EventHandlerContexts contexts = (EventHandlerContexts)handler_context;
            for (int i = 0; i < this.handlers.size(); ++i) {
                this.handlers.get(i).postRead(contexts.ctxs.get(i), fn_name, args);
            }
        }
    }

    @Override
    public void preWrite(Object handler_context, String fn_name, TBase result) throws TException {
        if (handler_context != null) {
            EventHandlerContexts contexts = (EventHandlerContexts)handler_context;
            for (int i = 0; i < this.handlers.size(); ++i) {
                this.handlers.get(i).preWrite(contexts.ctxs.get(i), fn_name, result);
            }
        }
    }

    @Override
    public void postWrite(Object handler_context, String fn_name, TBase result) throws TException {
        if (handler_context != null) {
            EventHandlerContexts contexts = (EventHandlerContexts)handler_context;
            for (int i = 0; i < this.handlers.size(); ++i) {
                this.handlers.get(i).postWrite(contexts.ctxs.get(i), fn_name, result);
            }
        }
    }

    @Override
    public void handlerError(Object handler_context, String fn_name, Throwable th) throws TException {
        if (handler_context != null) {
            EventHandlerContexts contexts = (EventHandlerContexts)handler_context;
            for (int i = 0; i < this.handlers.size(); ++i) {
                this.handlers.get(i).handlerError(contexts.ctxs.get(i), fn_name, th);
            }
        }
    }

    @Override
    public <T extends Throwable> void declaredUserException(Object handler_context, String fn_name, T th) throws TException {
        if (handler_context != null) {
            EventHandlerContexts contexts = (EventHandlerContexts)handler_context;
            for (int i = 0; i < this.handlers.size(); ++i) {
                this.handlers.get(i).declaredUserException(contexts.ctxs.get(i), fn_name, th);
            }
        }
    }

    private static class EventHandlerContexts {
        private final List<Object> ctxs = new ArrayList<Object>();

        public EventHandlerContexts(List<TProcessorEventHandler> handlers, String method, TConnectionContext connectionContext) {
            for (TProcessorEventHandler handler : handlers) {
                this.ctxs.add(handler.getContext(method, connectionContext));
            }
        }
    }
}

