/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.com.facebook.thrift;

import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TApplicationException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBase;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TClientIf;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TMessage;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocol;

public abstract class TServiceClient
implements TClientIf {
    protected TProtocol iprot_;
    protected TProtocol oprot_;
    protected int seqid_;

    public TServiceClient(TProtocol prot) {
        this(prot, prot);
    }

    public TServiceClient(TProtocol iprot, TProtocol oprot) {
        this.iprot_ = iprot;
        this.oprot_ = oprot;
    }

    @Override
    public TProtocol getInputProtocol() {
        return this.iprot_;
    }

    @Override
    public TProtocol getOutputProtocol() {
        return this.oprot_;
    }

    protected void sendBase(String methodName, TBase args) throws TException {
        this.sendBase(methodName, args, (byte)1);
    }

    protected void sendBaseOneway(String methodName, TBase args) throws TException {
        this.sendBase(methodName, args, (byte)4);
    }

    private void sendBase(String methodName, TBase args, byte type) throws TException {
        this.oprot_.writeMessageBegin(new TMessage(methodName, type, ++this.seqid_));
        args.write(this.oprot_);
        this.oprot_.writeMessageEnd();
        this.oprot_.getTransport().flush();
    }

    protected void receiveBase(TBase result, String methodName) throws TException {
        TMessage msg = this.iprot_.readMessageBegin();
        if (msg.type == 3) {
            TApplicationException x = new TApplicationException();
            TApplicationException.read(this.iprot_);
            this.iprot_.readMessageEnd();
            throw x;
        }
        if (msg.seqid != this.seqid_) {
            throw new TApplicationException(4, String.format("%s failed: out of sequence response: expected %d but got %d", methodName, this.seqid_, msg.seqid));
        }
        result.read(this.iprot_);
        this.iprot_.readMessageEnd();
    }
}

