/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.com.facebook.thrift.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TProcessor;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TProcessorFactory;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TBinaryProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolFactory;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.server.TNonblockingServer;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.server.TThreadFactoryImpl;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.TFramedTransport;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.TNonblockingServerTransport;

public class THsHaServer
extends TNonblockingServer {
    private ExecutorService invoker;
    protected final Options options_;

    public THsHaServer(TProcessor processor, TNonblockingServerTransport serverTransport) {
        this(processor, serverTransport, new Options());
    }

    public THsHaServer(TProcessor processor, TNonblockingServerTransport serverTransport, Options options) {
        this(new TProcessorFactory(processor), serverTransport, options);
    }

    public THsHaServer(TProcessorFactory processorFactory, TNonblockingServerTransport serverTransport) {
        this(processorFactory, serverTransport, new Options());
    }

    public THsHaServer(TProcessorFactory processorFactory, TNonblockingServerTransport serverTransport, Options options) {
        this(processorFactory, serverTransport, new TFramedTransport.Factory(), new TBinaryProtocol.Factory(), options);
    }

    public THsHaServer(TProcessor processor, TNonblockingServerTransport serverTransport, TProtocolFactory protocolFactory) {
        this(processor, serverTransport, protocolFactory, new Options());
    }

    public THsHaServer(TProcessor processor, TNonblockingServerTransport serverTransport, TProtocolFactory protocolFactory, Options options) {
        this(new TProcessorFactory(processor), serverTransport, new TFramedTransport.Factory(), protocolFactory, options);
    }

    public THsHaServer(TProcessor processor, TNonblockingServerTransport serverTransport, TFramedTransport.Factory transportFactory, TProtocolFactory protocolFactory) {
        this(new TProcessorFactory(processor), serverTransport, transportFactory, protocolFactory);
    }

    public THsHaServer(TProcessorFactory processorFactory, TNonblockingServerTransport serverTransport, TFramedTransport.Factory transportFactory, TProtocolFactory protocolFactory) {
        this(processorFactory, serverTransport, transportFactory, transportFactory, protocolFactory, protocolFactory, new Options());
    }

    public THsHaServer(TProcessorFactory processorFactory, TNonblockingServerTransport serverTransport, TFramedTransport.Factory transportFactory, TProtocolFactory protocolFactory, Options options) {
        this(processorFactory, serverTransport, transportFactory, transportFactory, protocolFactory, protocolFactory, options);
    }

    public THsHaServer(TProcessor processor, TNonblockingServerTransport serverTransport, TFramedTransport.Factory inputTransportFactory, TFramedTransport.Factory outputTransportFactory, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory) {
        this(new TProcessorFactory(processor), serverTransport, inputTransportFactory, outputTransportFactory, inputProtocolFactory, outputProtocolFactory);
    }

    public THsHaServer(TProcessorFactory processorFactory, TNonblockingServerTransport serverTransport, TFramedTransport.Factory inputTransportFactory, TFramedTransport.Factory outputTransportFactory, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory) {
        this(processorFactory, serverTransport, inputTransportFactory, outputTransportFactory, inputProtocolFactory, outputProtocolFactory, new Options());
    }

    public THsHaServer(TProcessorFactory processorFactory, TNonblockingServerTransport serverTransport, TFramedTransport.Factory inputTransportFactory, TFramedTransport.Factory outputTransportFactory, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory, Options options) {
        super(processorFactory, serverTransport, inputTransportFactory, outputTransportFactory, inputProtocolFactory, outputProtocolFactory, options);
        this.options_ = options;
    }

    @Override
    public void serve() {
        if (!this.startInvokerPool()) {
            return;
        }
        if (!this.startListening()) {
            return;
        }
        if (!this.startSelectorThread()) {
            return;
        }
        this.joinSelector();
        this.gracefullyShutdownInvokerPool();
        this.stopListening();
    }

    protected boolean startInvokerPool() {
        SynchronousQueue<Runnable> queue = this.options_.hsHaQueueSize == 0 ? new SynchronousQueue() : new LinkedBlockingQueue(this.options_.hsHaQueueSize);
        this.invoker = new ThreadPoolExecutor(this.options_.minHsHaWorkerThreads, this.options_.maxHsHaWorkerThreads, (long)this.options_.stopTimeoutVal, this.options_.stopTimeoutUnit, queue, new TThreadFactoryImpl("THsHaServer-Invoker"));
        return true;
    }

    protected void gracefullyShutdownInvokerPool() {
        long newnow;
        this.invoker.shutdown();
        long now = System.currentTimeMillis();
        for (long timeoutMS = 10000L; timeoutMS >= 0L; timeoutMS -= newnow - now) {
            try {
                this.invoker.awaitTermination(timeoutMS, TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException ix) {
                newnow = System.currentTimeMillis();
                now = newnow;
                continue;
            }
        }
    }

    @Override
    protected void requestInvoke(TNonblockingServer.FrameBuffer frameBuffer) throws TNonblockingServer.ServerOverloadedException {
        try {
            this.invoker.execute(new Invocation(frameBuffer));
        }
        catch (RejectedExecutionException e) {
            throw new TNonblockingServer.ServerOverloadedException(e);
        }
    }

    public static class Options
    extends TNonblockingServer.Options {
        public int minHsHaWorkerThreads = 8;
        public int maxHsHaWorkerThreads = Integer.MAX_VALUE;
        public int hsHaQueueSize = Integer.MAX_VALUE;
        public int stopTimeoutVal = 60;
        public TimeUnit stopTimeoutUnit = TimeUnit.SECONDS;
    }

    private static class Invocation
    implements Runnable {
        private final TNonblockingServer.FrameBuffer frameBuffer;

        public Invocation(TNonblockingServer.FrameBuffer frameBuffer) {
            this.frameBuffer = frameBuffer;
        }

        @Override
        public void run() {
            this.frameBuffer.invoke();
        }
    }
}

