/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.com.facebook.thrift.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TProcessor;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolFactory;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.server.TConnectionContext;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.TIOStreamTransport;
import org.apache.flink.connector.nebula.shaded.javax.servlet.ServletException;
import org.apache.flink.connector.nebula.shaded.javax.servlet.ServletInputStream;
import org.apache.flink.connector.nebula.shaded.javax.servlet.ServletOutputStream;
import org.apache.flink.connector.nebula.shaded.javax.servlet.http.HttpServlet;
import org.apache.flink.connector.nebula.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.flink.connector.nebula.shaded.javax.servlet.http.HttpServletResponse;

public class TServlet
extends HttpServlet {
    private final TProcessor processor;
    private final TProtocolFactory inProtocolFactory;
    private final TProtocolFactory outProtocolFactory;
    private final Collection<Map.Entry<String, String>> customHeaders;

    public TServlet(TProcessor processor, TProtocolFactory inProtocolFactory, TProtocolFactory outProtocolFactory) {
        this.processor = processor;
        this.inProtocolFactory = inProtocolFactory;
        this.outProtocolFactory = outProtocolFactory;
        this.customHeaders = new ArrayList<Map.Entry<String, String>>();
    }

    public TServlet(TProcessor processor, TProtocolFactory protocolFactory) {
        this(processor, protocolFactory, protocolFactory);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        TIOStreamTransport inTransport = null;
        TIOStreamTransport outTransport = null;
        try {
            TIOStreamTransport transport;
            response.setContentType("application/x-thrift");
            if (null != this.customHeaders) {
                for (Map.Entry<String, String> header : this.customHeaders) {
                    response.addHeader(header.getKey(), header.getValue());
                }
            }
            ServletInputStream in = request.getInputStream();
            ServletOutputStream out = response.getOutputStream();
            inTransport = transport = new TIOStreamTransport(in, out);
            outTransport = transport;
            TProtocol inProtocol = this.inProtocolFactory.getProtocol(inTransport);
            TProtocol outProtocol = this.outProtocolFactory.getProtocol(outTransport);
            TConnectionContext server_ctx = new TConnectionContext(inProtocol, outProtocol);
            this.processor.process(inProtocol, outProtocol, server_ctx);
            out.flush();
        }
        catch (TException te) {
            throw new ServletException(te);
        }
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void addCustomHeader(final String key, final String value) {
        this.customHeaders.add(new Map.Entry<String, String>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public String getValue() {
                return value;
            }

            @Override
            public String setValue(String value2) {
                return null;
            }
        });
    }

    public void setCustomHeaders(Collection<Map.Entry<String, String>> headers) {
        this.customHeaders.clear();
        this.customHeaders.addAll(headers);
    }
}

