/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport;

import java.io.UnsupportedEncodingException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TByteArrayOutputStream;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.TTransport;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.TTransportException;

public class TMemoryBuffer
extends TTransport {
    private TByteArrayOutputStream arr_;
    private int pos_;

    public TMemoryBuffer(int size) {
        this.reset(size);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        int amtToRead;
        byte[] src = this.arr_.get();
        int n = amtToRead = len > this.arr_.len() - this.pos_ ? this.arr_.len() - this.pos_ : len;
        if (amtToRead > 0) {
            System.arraycopy(src, this.pos_, buf, off, amtToRead);
            this.pos_ += amtToRead;
        }
        return amtToRead;
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.arr_.write(buf, off, len);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return this.arr_.toString(enc);
    }

    public String inspect() {
        String buf = "";
        byte[] bytes = this.arr_.toByteArray();
        for (int i = 0; i < bytes.length; ++i) {
            buf = buf + (this.pos_ == i ? "==>" : "") + Integer.toHexString(bytes[i] & 0xFF) + " ";
        }
        return buf;
    }

    public int length() {
        return this.arr_.len();
    }

    public void reset(int size) {
        this.arr_ = new TByteArrayOutputStream(size);
        this.pos_ = 0;
    }

    public byte[] getArray() {
        return this.arr_.get();
    }

    public int getArrayPos() {
        return this.pos_;
    }
}

