/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.InteriorPointArea;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.InteriorPointLine;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.InteriorPointPoint;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.GeometryFactory;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Point;

public class InteriorPoint {
    public static Point getInteriorPoint(Geometry geom) {
        GeometryFactory factory = geom.getFactory();
        if (geom.isEmpty()) {
            return InteriorPoint.createPointEmpty(factory);
        }
        Coordinate interiorPt = null;
        int dim = geom.getDimension();
        interiorPt = dim == 0 ? InteriorPointPoint.getInteriorPoint(geom) : (dim == 1 ? InteriorPointLine.getInteriorPoint(geom) : InteriorPointArea.getInteriorPoint(geom));
        return InteriorPoint.createPointPrecise(factory, interiorPt);
    }

    private static Point createPointEmpty(GeometryFactory factory) {
        return factory.createPoint();
    }

    private static Point createPointPrecise(GeometryFactory factory, Coordinate coord) {
        factory.getPrecisionModel().makePrecise(coord);
        return factory.createPoint(coord);
    }
}

